<?php
if (!defined('ABSPATH')) {
    exit;
}
?>

<div class="wrap">
    <h1><?php echo esc_html(get_admin_page_title()); ?></h1>
    
    <div id="poststuff">
        <div id="post-body" class="metabox-holder columns-2">
            <!-- Coluna principal -->
            <div id="post-body-content">
                <div class="postbox">
                    <form method="post" 
                          action="<?php echo esc_url(admin_url('admin.php?page=usuario_loja')); ?>" 
                          id="form_usuario_loja" 
                          enctype="multipart/form-data">
                        <?php 
                        wp_nonce_field('usuario_loja', 'criar_usuario_loja_nonce');
                        ?>
                        <input type="hidden" name="modo" value="criar_novo">
                        
                        <div class="postbox-header">
                            <h2>Dados do Usuário</h2>
                        </div>
                        <div class="inside">
                            <table class="form-table">
                                <!-- Campos do Usuário -->
                                <tr>
                                    <th><label for="criar_username">Nome de Usuário</label></th>
                                    <td>
                                        <input type="text" name="username" id="criar_username" 
                                               class="regular-text" required autocomplete="name">
                                        <p class="description">Nome que será exibido publicamente.</p>
                                    </td>
                                </tr>
                                <tr>
                                    <th><label for="criar_email">E-mail</label></th>
                                    <td>
                                        <input type="email" name="email" id="criar_email" 
                                               class="regular-text" required autocomplete="email">
                                        <p class="description">E-mail principal para contato e login.</p>
                                    </td>
                                </tr>
                                <tr>
                                    <th><label for="criar_password">Senha</label></th>
                                    <td>
                                        <input type="password" name="password" id="criar_password" 
                                               class="regular-text" required autocomplete="new-password">
                                        <p class="description">Senha para acesso ao sistema.</p>
                                    </td>
                                </tr>
                            </table>
                        </div>

                        <div class="postbox-header" style="border-top: 1px solid #c3c4c7;">
                            <h2>Dados da Loja</h2>
                        </div>
                        <div class="inside">
                            <table class="form-table">
                                <tr>
                                    <th><label for="criar_nome_loja">Nome da Loja*</label></th>
                                    <td>
                                        <input type="text" name="nome_loja" id="criar_nome_loja" 
                                               class="regular-text" required autocomplete="organization">
                                        <p class="description">Nome que será exibido ao longo do site.<br><b>*Campo obrigatório.</b></p>
                                    </td>
                                </tr>
                                <tr>
                                    <th><label for="criar_tipo_integracao">Tipo de integração</label></th>
                                    <td>
                                        <select name="tipo_integracao" id="criar_tipo_integracao" class="regular-text">
                                            <option value="altimus">Altimus</option>
                                            <option value="api">API</option>
                                            <option value="json">Leitura JSON</option>
                                        </select>
                                        <p class="description">Selecionar a forma que os veículos serão recebidos no site. O padrão é Altimus.</p>
                                    </td>
                                </tr>
                                <tr id="json_url_row" style="display:none;">
                                    <th><label for="criar_json_url">URL do JSON*</label></th>
                                    <td>
                                        <input type="url" name="json_url" id="json_url_row" class="regular-text">
                                        <p class="description">Informe a URL onde o JSON com os veículos está localizado. <br><b>*Campo obrigatório quando tipo de integração for JSON</b></p>
                                    </td>
                                </tr>
                                <tr>
                                    <th><label for="criar_whatsapp">Whatsapp*</label></th>
                                    <td>
                                        <input type="text" name="whatsapp" id="criar_whatsapp" class="regular-text">
                                        <p class="description">Informe apenas os números.<br><b>*Campo obrigatório.</b></p>
                                    </td>
                                </tr>
                                <tr>
                                    <th><label for="criar_link_loja">Link da Loja*</label></th>
                                    <td>
                                        <input type="url" name="link_loja" id="criar_link_loja" class="regular-text">
                                        <p class="description">URL do site da loja.<br><b>*Campo obrigatório.</b></p>
                                    </td>
                                </tr>
                                <tr>
                                    <th><label for="criar_cnpj">CNPJ</label></th>
                                    <td>
                                        <input type="text" name="cnpj" id="criar_cnpj" class="regular-text">
                                        <p class="description">Informe apenas os números.</p>
                                    </td>
                                </tr>
                                <tr>
                                    <th><label for="criar_frase">Frase/Slogan</label></th>
                                    <td><input type="text" name="frase" id="criar_frase" class="regular-text"></td>
                                </tr>
                                <tr>
                                    <th><label for="criar_telefone">Telefone</label></th>
                                    <td>
                                        <input type="text" name="telefone" id="criar_telefone" class="regular-text">
                                        <p class="description">Informe apenas os números.</p>
                                    </td>
                                </tr>
                                <tr>
                                    <th><label for="criar_email_loja">E-mail da Loja</label></th>
                                    <td><input type="email" name="email_loja" id="criar_email_loja" class="regular-text"></td>
                                </tr>
                                <tr>
                                    <th><label for="criar_endereco">Endereço</label></th>
                                    <td><input type="text" name="endereco" id="criar_endereco" class="regular-text"></td>
                                </tr>
                                <tr>
                                    <th><label for="criar_cidade">Cidade</label></th>
                                    <td><input type="text" name="cidade" id="criar_cidade" class="regular-text"></td>
                                </tr>
                                <tr>
                                    <th><label for="criar_estado">Estado</label></th>
                                    <td>
                                        <select name="estado" id="criar_estado" class="regular-text">
                                            <?php
                                            $estados = alt_get_lista_estados();
                                            foreach ($estados as $sigla => $estado) {
                                                echo '<option value="' . esc_attr($sigla) . '">' . esc_html($estado) . '</option>';
                                            }
                                            ?>
                                        </select>
                                    </td>
                                </tr>
                                <tr>
                                    <th><label for="criar_cep">CEP</label></th>
                                    <td>
                                        <input type="text" name="cep" id="criar_cep" class="regular-text">
                                        <p class="description">Informe apenas os números.</p>
                                    </td>
                                </tr>
                                <tr>
                                    <th><label for="criar_google_maps">Link Google Maps</label></th>
                                    <td>
                                        <input type="url" name="google_maps" id="criar_google_maps" class="regular-text">
                                        <p class="description">URL da localização no Google Maps</p>
                                    </td>
                                </tr>
                                <tr>
                                    <th><label for="criar_logo">Logo da Loja</label></th>
                                    <td>
                                        <img src="" id="logo-preview" style="max-width:200px; margin-bottom:10px; display:block;">
                                        <input type="file" name="logo" id="criar_logo" class="regular-text" 
                                               accept="image/gif,image/jpeg,image/png,image/webp">
                                        <p class="description">Selecione uma imagem para a logo da empresa (GIF, JPEG, PNG ou WEBP).</p>    
                                    </td>
                                </tr>
                            </table>
                        </div>
                        <div id="major-publishing-actions">
                            <div id="delete-action">
                                <a href="<?php echo esc_url(admin_url('admin.php?page=usuario_loja')); ?>" 
                                   class="button">Cancelar</a>
                            </div>
                            <div id="publishing-action">
                                <span class="spinner"></span>
                                <input type="submit" name="submit_usuario_loja" id="publish" 
                                       class="button button-primary button-large" 
                                       value="Criar Usuário e Loja">
                            </div>
                            <div class="clear"></div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>

<script>
jQuery(document).ready(function($) {
    // Preview da logo
    function readURL(input) {
        if (input.files && input.files[0]) {
            var reader = new FileReader();
            
            reader.onload = function(e) {
                if (!$('#logo-preview').length) {
                    $(input).before('<img id="logo-preview" src="" style="max-width:200px; margin-bottom:10px; display:block;"/>');
                }
                $('#logo-preview').attr('src', e.target.result);
            }
            
            reader.readAsDataURL(input.files[0]);
        }
    }

    $("#criar_logo").change(function() {
        readURL(this);
    });
});
</script>