<?php

require_once plugin_dir_path(__FILE__) . '../metabox/metabox_loja.php';

// Função para registrar o Custom Post Type "Sobre"
function alt_loja()
{
    $args_loja_post_type = array(
        'labels' => array(
            'name' => 'Loja',
            'singular_name' => 'Loja',
            'add_new' => 'Adicionar Novo',
            'add_new_item' => 'Adicionar Nova Loja',
            'edit_item' => 'Editar Loja',
            'new_item' => 'Nova Loja',
            'view_item' => 'Ver Loja',
            'search_items' => 'Pesquisar Loja',
            'not_found' => 'Nenhuma loja encontrada',
            'not_found_in_trash' => 'Nenhuma loja encontrada na lixeira'
        ),
        'public' => true,
        'has_archive' => true,
        'menu_icon' => 'dashicons-format-image',
        'supports' => array('title'),
        'show_in_menu' => false, // Isso oculta o menu padrão do Custom Post Type
    );
    register_post_type('lojas', $args_loja_post_type);
}
add_action('init', 'alt_loja');

// Exibe aviso no metabox de Loja
function alt_check_users_before_adding_loja($post)
{
    global $typenow;
    if (($typenow == 'lojas' && $post && !$post->ID && !alt_get_usuarios()) || (current_user_can('lojista'))) {
?>
        <style>
            /* Oculta o botão "Adicionar Novo" */
            .post-type-lojas .page-title-action {
                display: none;
            }
        </style>
    <?php

    }

    if (($typenow == 'lojas' && $post && !$post->ID && !alt_get_usuarios())) {
    ?>
        <div class="notice notice-warning" style="margin: 15px 0;">
            <p><strong>Nota:</strong> Não é possível adicionar uma nova Loja. Todos os usuários já estão vinculados a uma loja. É necessário cadastrar um novo usuário.</p>
        </div>
<?php
    }
}
add_action('admin_footer', 'alt_check_users_before_adding_loja');

function alt_img_loja(){

    $relative_url = '';
    $site_url = get_home_url();
    $img = get_post_meta(get_the_ID(), 'alt_lojas_imagem', true); 

    if($img){
        $site_url = str_replace(['http://', 'https://'], '', $site_url);
        $img = str_replace(['http://', 'https://'], '', $img);
        $relative_url = str_replace($site_url, '', $img);
    }

    return $relative_url;
}

/**
 * Adiciona o botão de exportação na listagem de lojas
 *
 * @param string $which Posição dos elementos na tabela ('top' ou 'bottom')
 */
function alt_adicionar_botao_exportar($which) {
    global $typenow;
    
    // Verifica se estamos na listagem do CPT 'lojas'
    if ($typenow == 'lojas' && $which == 'top') {
        ?>
        <div class="alignleft actions">
            <a href="<?php echo esc_url(admin_url('admin-post.php?action=exportar_planilha')); ?>" class="button button-primary">
                Exportar Dados para Planilha
            </a>
        </div>
        <?php
    }
}
add_action('manage_posts_extra_tablenav', 'alt_adicionar_botao_exportar');

/**
 * Função para exportar os dados do Custom Post Type "Lojas" para uma planilha
 */
function alt_get_status_loja($loja_id)
{
    $status = get_post_meta($loja_id, 'alt_lojas_status_loja', true);
    if ($status == 'inativa') {
        return 'Inativa';
    } else {
        return 'Ativa';
    }
}

function alt_data_inatividade_loja($loja_id)
{
    $data = get_post_meta($loja_id, 'alt_lojas_data_inatividade', true);
    if ($data) {
        return date('d/m/Y', strtotime($data));
    }
}

//Função que vai buscar a data de inativação(alt_lojas_data_inatividade) e calcular os dias utilizando o campo alt_portal_selecionar_limite_inatividade para exibir a data que deve ser excluido a loja
function alt_get_prazo_exclusao_loja($loja_id)
{
    $data = get_post_meta($loja_id, 'alt_lojas_data_inatividade', true);
    $limite = get_option('alt_portal_config')['portal_limite_inatividade'];
    
    if ($data && $limite) {
        $data_exclusao = date('d/m/Y', strtotime($data . " + $limite days"));
        return $data_exclusao;
    }    
    return '';
}

//Função recebe o id da loja, com base no id, identifica o usuário da loja que é o mesmo post_author e retorna a quantidade de veículos
function alt_get_qtd_veiculos_loja($loja_id)
{
    $user_id = get_post_field('post_author', $loja_id);
    $args = array(
        'post_type' => 'veiculos',
        'author' => $user_id,
        'posts_per_page' => -1,
        'post_status' => 'publish'
    );
    $query = new WP_Query($args);
    return $query->found_posts;
}