<?php

if (file_exists(dirname(__FILE__) . '/cmb2/init.php')) {
    require_once dirname(__FILE__) . '/cmb2/init.php';
} elseif (file_exists(dirname(__FILE__) . '/CMB2/init.php')) {
    require_once dirname(__FILE__) . '/CMB2/init.php';
}

add_action('cmb2_init', 'cmb2_sample_metaboxes');
/**
 * Define the metabox and field configurations.
 */
function cmb2_sample_metaboxes()
{

    // Start with an underscore to hide fields from custom fields list
    $prefix = 'alt_';

    /**
     * Initiate the metabox
     */
    $cmb = new_cmb2_box(array(
        'id' => 'dados_do_veiculo',
        'title' => __('Dados do veiculo', 'cmb2'),
        'object_types' => array('product',), // Post type
        'context' => 'normal',
        'priority' => 'high',
        'show_names' => true,
        'show_in_rest' => WP_REST_Server::READABLE,
    ));

    $cmb->add_field(array(
            'name' => __('kilometragem', 'cmb2'),
            'desc' => __('Informe a kilometragem do veículo', 'cmb2'),
            'id' => $prefix . 'kilometragem',
            'type' => 'text',

            'show_on_cb' => 'cmb2_hide_if_no_cats',
            'attributes' => array(
                'required' => 'required',
            ),
        )
    );

    $cmb->add_field(array(
            'name' => __('Ano modelo', 'cmb2'),
            'desc' => __('Informe a Ano/modelo do veículo', 'cmb2'),
            'id' => $prefix . 'ano_mod',
            'type' => 'text',
            'show_on_cb' => 'cmb2_hide_if_no_cats',
            'attributes' => array(
                'required' => 'required',
            ),
        )
    );

    $cmb->add_field(array(
            'name' => __('Cambio', 'cmb2'),
            'desc' => __('Informe a tipo de câmbio', 'cmb2'),
            'id' => $prefix . 'cambio',
            'type' => 'text',
            'show_on_cb' => 'cmb2_hide_if_no_cats',
            'attributes' => array(
                'required' => 'required',
            ),
        )
    );

    $cmb->add_field(array(
            'name' => __('Localizacao', 'cmb2'),
            'desc' => __('Informe a localização do veículo', 'cmb2'),
            'id' => $prefix . 'localizacao',
            'type' => 'text',
            'show_on_cb' => 'cmb2_hide_if_no_cats',
            'attributes' => array(
                'required' => 'required',
            ),
        )
    );

    $cmb->add_field(array(
            'name' => __('ano de fabricacao', 'cmb2'),
            'desc' => __('Informe a ano de fabricacao do veículo', 'cmb2'),
            'id' => $prefix . 'ano_fab',
            'type' => 'text',
            'show_on_cb' => 'cmb2_hide_if_no_cats',

        )
    );

    $cmb->add_field(array(
            'name' => __('Combustivel', 'cmb2'),
            'desc' => __('Informe a tipo de combustivel', 'cmb2'),
            'id' => $prefix . 'combustivel',
            'type' => 'text',
            'show_on_cb' => 'cmb2_hide_if_no_cats',
        )
    );

    $cmb->add_field(array(
            'name' => __('Portas', 'cmb2'),
            'desc' => __('Quantidade de portas', 'cmb2'),
            'id' => $prefix . 'portas',
            'type' => 'text',
            'show_on_cb' => 'cmb2_hide_if_no_cats',
        )
    );

}
