<?php
function alt_remove_all_style()
{

    wp_dequeue_style('bootstrap');
    wp_dequeue_script('bootstrap-js');
    global $wp_styles;


    $arrIgnore = ['def-padrao-style', 'shorcode-whatsapp-style', 'wp-block-library', 'admin-bar'];

    foreach ($wp_styles->queue as $style) {

        if (!in_array($style, $arrIgnore)) {

            wp_dequeue_style($style);
            wp_deregister_style($style);
            wp_dequeue_style($style);
            wp_deregister_style($style);
            wp_dequeue_script($style);
        }
    }
}

add_action('wp_enqueue_scripts', 'alt_remove_all_style', 10);


global $post;
$post_id = $post->ID;
$objMarca = get_the_terms($post_id, 'marca');
$marca = $objMarca[0]->name;
$logo_marca = get_term_meta($objMarca[0]->term_id, 'marca_img', true);

$url_logo = alt_url_logo();

$objModelo = get_the_terms($post_id, 'modelo');
$modelo = $objModelo[0]->name;

$observacoes = $post->post_content;

$complemento = get_post_meta($post_id, 'alt_modelo_complemento', true);
$preco = get_preco_veiculo($post_id);
$titulo = get_titulo_produto($post_id, true, true);
$arrInfo = alt_get_filiais();


$arrOpcionais = alt_get_caracteristicas($post_id, 'alt_acessorios');
$arrImagens = alt_list_images($post_id);
$lista_imagens = alt_get_imagens_veiculo($post->ID);
$url_foto_principal = alt_get_imagem_destaque($post->ID, $lista_imagens);

$arrDepoimentos = alt_get_depoimentos();

$url_files = plugin_dir_url(__FILE__) . 'assets/';
if (!isset($arrInfo[0])) {
    die('Informe uma matriz');
}
$nome_fantasia = $arrInfo[0]['nome_fantasia'] ?? null;
$telefone = $arrInfo[0]['telefone'] ?? null;
$url_telefone = $arrInfo[0]['url_telefone'] ?? null;
$whatsapp = $arrInfo[0]['whatsapp'] ?? null;
$url_whatsapp = $arrInfo[0]['url_whatsapp'] ?? null;
$endereco_completo = $arrInfo[0]['endereco_completo'] ?? null;
if (empty($endereco_completo)) {
    die('Endereço da revenda não informado na matriz');
}
$url_endereco = 'https://www.google.com.br/maps/place/' . $endereco_completo;

// if (!empty($arrImagens)) {
//     $url_foto_principal = array_shift(array_values($arrImagens)) ?? get_alt_url_imagem_veiculo($post_id, 'full', ['class' => 'img-responsive card-img-top']);
// } else {
//     $url_foto_principal = '';
// }


$largura = 750;
$altura = 450;
if (wp_is_mobile()) {
    $largura = 400; #intro-features .section-content
    $altura = 350;
}
$youtube = alt_get_video($post_id);

$arrVeiculos = [];

if (isset($_GET['similares'])) {
    $total_similares = $_GET['similares'] ?? 6;
    $arrVeiculos = get_veiculos_similares($post_id, $total_similares);
}

$quilometragem = alt_get_caracteristicas($post_id, 'alt_kilometragem') ?? 'Não declarado';
$ano_modelo = alt_get_caracteristicas($post_id, 'alt_ano_mod') ?? 'Não declarado';
$cambio = alt_get_caracteristicas($post_id, 'alt_cambio') ?? 'Não declarado';
$combustivel = get_post_meta($post_id, 'alt_combustivel', true);
$portas = get_post_meta($post_id, 'alt_portas', true);
$cor = get_post_meta($post_id, 'alt_cor', true);


$contadores = alt_get_total_visualizacoes_numero($post_id);
if ($contadores < 15) {
    $contadores = null;
}
$titulo_site = 'Oferta imperdivel ' . $marca . ' ' . $modelo . ' ' . $complemento . ' ' . $ano_modelo;


//global $wp;
//$current_url = home_url(add_query_arg(array(), $wp->request));
$url_anuncio = get_permalink($post_id);
$url_redirec_whatsapp = '/wp-json/altimus/v1/whatsapp?text=Ola gostaria de mais informações sobre *' . $titulo_site . '* ' . $url_anuncio;

alt_set_post_view($post_id);
?>
<!DOCTYPE html>
<html lang="pt-BR">

<head>

    <!-- Meta
    ============================================= -->
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1">

    <!-- Stylesheets
    ============================================= -->
    <link href="<?= $url_files ?>css/bootstrap.min.css" rel="stylesheet">
    <link href="<?= $url_files ?>icomoon/style.css" rel="stylesheet">
    <link href="https://cdn-wordpress.altimus.com.br/wp-files/icomoon/style.css" rel="stylesheet">
    <link href="<?= $url_files ?>css/style.css" rel="stylesheet">

    <link href="https://fonts.googleapis.com/css?family=Montserrat:400,400i,700,700i" rel="stylesheet">
    <link href="https://fonts.googleapis.com/css?family=Lato:400,400i,700,700i" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.3/css/all.min.css" rel="stylesheet">


    <!-- Favicon
    ============================================= -->
    <link rel="shortcut icon" href="images/general-elements/favicon/favicon.png">
    <link rel="apple-touch-icon" href="images/general-elements/favicon/apple-touch-icon.png">
    <link rel="apple-touch-icon" sizes="72x72" href="images/general-elements/favicon/apple-touch-icon-72x72.png">
    <link rel="apple-touch-icon" sizes="114x114" href="images/general-elements/favicon/apple-touch-icon-114x114.png">
    <!-- Title
    ============================================= -->


    <?php wp_head(); ?>


</head>
<style>
html {
    margin-top: 0px !important;
}

h1,
h2,
h3,
h4,
h5,
h6 {
    font-weight: 700;
}

p {
    color: #999;
}

.alerta-cta {
    background: #ffa500;
    color: #000;
    padding: 10px 30px;
    margin-top: 15px;
}

.price {
    color: #fff;
    font-weight: bolder;
    font-size: 50px;
}

.box-project-house .box-content {
    min-height: 180px;
}

.btn-whatsapp,
.btn-whatsapp:hover,
.btn-whatsapp:link {
    text-transform: uppercase;
    font-weight: 600;
    border: none;
    color: #fff;
    background: #24c162;
    transition: all 0.2s;
    border-radius: 4px;
    border: none;
    width: 100%;
    display: block;
    text-align: center;
    padding: 20px;
    text-decoration: none;
}


.box-info .box-icon {
    margin: 0px 20px 0 0;
}

.center-vertical .section-content>.container>.row {
    display: block;
}


.box-content p {
    font-size: 20px;
}

.address a {
    font-size: 15px;
    font-weight: 700;
}

.box-content h4 {
    margin-bottom: 0px;
}

.box-content .price {
    font-size: 24px;
}

.icon.x2 {
    font-size: 40px;
}

.box-opcionais ul {
    list-style: none;
}

.box-info .box-icon {
    color: #f00;
}

.arrow-down {
    width: 0;
    height: 0;
    border-left: 60px solid transparent;
    border-right: 60px solid transparent;
    border-top: 20px solid #f00;
    position: absolute;
    z-index: 100;
    right: 50%;
    display: none;
}

.sidebar_widget {
    border: none;
    margin: 0;
    padding: 0;
    position: relative;
}

.widget_heading {
    display: none;
}

.hover-whatsapp {
    background-color: #2CB742;
    color: #fff;
}

.hover-whatsapp:hover {
    background-color: #2CB742;
    color: #fff;
}

label {
    float: left;
    display: block;
    margin-bottom: 5px;
    cursor: pointer;
    text-align: left;
    font-family: "Montserrat", "Droid Arabic Kufi", sans-serif;
    font-size: 14px;
    font-weight: 700;
    color: #999;
}


#fotos>.owl-carousel .owl-dots {
    position: absolute;
    margin-left: auto;
    margin-right: auto;
    left: 0;
    right: 0;
    bottom: 0px;
}

.btn-call,
.btn-call:hover {
    padding: 20px;
    text-transform: uppercase;
    font-weight: 600;
    border: none;
    color: #fff;
    background: #f00;
    transition: all 0.2s;
    border-radius: 4px;
    border: none;
    width: 100%;
    display: block;
    text-align: center;
    padding: 20px;
    text-decoration: none;
}

.btn-cta {
    font-size: 20px;
}

.session-address {
    margin-top: 20px;
    border: 1px solid #e0e0e0;
    height: 110px;
}

.session-address .box-icone,
.box-address {
    float: left;
    height: 110px;
}

.session-address .box-icone {
    width: 20%;
    background-color: #f00;
    text-align: center;
    padding-top: 40px;
}

.session-address .box-icone i {
    font-size: 30px;
    color: #ffff;

}

.session-address .box-address {
    width: 80%;
    padding: 20px 25px;
}

.session-address .box-address .title {
    font-weight: 800;
}

.btn-map {
    background: #f00;
    transition: all 0.2s;
    color: #fff;
    border-radius: 4px;
    padding: 0px 20px;
}

.modal {
    position: fixed;
    top: 0;
    right: 0;
    bottom: 0;
    left: 0;
    z-index: 1050;
    display: none;
    overflow: hidden;
    -webkit-overflow-scrolling: touch;
    outline: 0;
}

.fade {
    opacity: 0;
    -webkit-transition: opacity .15s linear;
    -o-transition: opacity .15s linear;
    transition: opacity .15s linear;
}


.btn-whatsapp-float {
    font-size: 35px !important;
    padding-top: 0px !important;
}

.btn-primary {
    color: #fff;
    background-color: #585858;
}

.testimonial-single-1 .ts-content {
    min-height: 350px;
}

.bg_whatsapp {
    background-image: url('<?= $url_files ?>images/bg_whatsapp.jpg');
    min-height: 200px;
    padding: 20px;
    border-radius: 20px;
}

.block_whatsapp_talk {
    background: #fff;
    padding: 10px 10px 10px 21px;
    border: 1px solid #e6e6e6;
    width: 90%;
    color: #000;
    font-size: 13px;
    border-top-right-radius: 20px;
    border-bottom-right-radius: 20px;
    border-bottom-left-radius: 20px;
}

.float_whatsapp {
    position: fixed;
    right: 20px;
    bottom: 70px;
    font-size: 50px;
    z-index: 1000;
}

@media only screen and (max-width: 768px) {


    .hover-whatsapp {
        width: 100%;
    }

    #fale-conosco .section-content {
        padding: 50px 0px;
    }

    .box-form .form-group input[type="submit"] {
        font-size: 14px;
    }

    .register-house .box-content {
        padding: 35px 20px 45px;
    }

    .btn.colorful,
    .btn.hover-colorful:hover {
        width: 100%;
    }


    .arrow-down {
        margin-left: auto;
        margin-right: auto;
        left: 0;
        right: 0;
        text-align: center;
        display: block;
    }

    .session-address .box-address {
        width: 80%;
        padding: 10px 25px;
    }

    .float_whatsapp {
        right: 10px;
        bottom: 10px;
    }
}

.box-opcionais {
    max-height: 110px;
    overflow: hidden;


}

.box-observacoes {
    white-space: pre-line;
}

.btn-more {
    cursor: pointer;
    border: 2px solid;
    border-radius: 10px;
    padding: 0px 15px;
}

.owl-prev,
.owl-next {
    width: 15px;
    height: 100px;
    position: absolute;
    top: 50%;
    display: block !important;
}


.owl-prev {
    left: 15px;
}

.owl-next {
    right: 15px;
}

.owl-prev i,
.owl-next i {
    transform: scale(2, 5);
    color: #ccc;
}

span.preco_veiculo {
    font-size: 40px;
    text-decoration: line-through;
}


span.preco_promocional {
    color: white;
    font-weight: 800 !important;
}
</style>

<?php
remove_action('after_body_open_tag', 'alt_whatsapp_float');
?>

<body <?php body_class(); ?>>
    <?php do_action('after_body_open_tag'); ?>

    <div id="scroll-progress">
        <div class="scroll-progress"><span class="scroll-percent"></span></div>
    </div>
    <!-- Loading Progress
============================================= -->
    <div id="loading-progress">
        <a class="logo" href="#">
            <img src="<?= $url_logo ?>" data-logo-alt="<?= $url_logo ?>" alt="<?= $nome_fantasia ?>">
            <h3><span class="colored"><?= $nome_fantasia ?></span></h3>
            <span><?= $nome_fantasia ?></span>
        </a><!-- .logo end -->
        <div class="lp-content">
            <div class="lp-counter">
                Carregando
                <div id="lp-counter">0%</div>
            </div><!-- .lp-counter end -->
            <div class="lp-bar">
                <div id="lp-bar"></div>
            </div><!-- .lp-bar end -->
        </div><!-- .lp-content end -->
    </div><!-- #loading-progress end -->


    <!-- <section id="modal_whatsapp">

        <div class="float_whatsapp">
            <a href="#whatsapp" data-toggle="modal" data-target="#modelId">
                <img src="<?= $url_files ?>images/whatsapp.png">
            </a>
        </div>
-->
    <!-- Modal -->
    <div class="modal fade" id="modelId" tabindex="-1" role="dialog" aria-labelledby="modelTitleId" aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="bg_whatsapp">
                <div class="block_whatsapp_talk">
                    <strong>Olá</strong><br>
                    Clique no botão abaixo para continuar
                    <br>
                    esta conversa no whatsapp.
                </div>


                <div class="text-center mt-30">
                    <a target="_blank" href="<?= $url_redirec_whatsapp ?>" id="novo_btn_whatsapp_modal"
                        class="btn-whatsapp-block btn btn-whatsapp">
                        <i class="fab fa-whatsapp"></i>
                        Conversar por whatsapp
                    </a>
                    <div class="div-voltar-whastapp">
                        <a data-dismiss="modal">Consultar depois.</a>
                    </div>
                </div>
            </div>
        </div>
    </div>
    </section>

    <!-- Document Full Container
============================================= -->
    <div id="full-container">


        <!-- Header
    ============================================= -->
        <header id="header" class="" data-scroll-index="0">

            <div id="header-wrap">

                <div class="container">
                    <div class="row">
                        <div class="col-xs-6 col-md-12">


                            <!--<a class="logo logo-header" href="#">

                            <img src="<?= $url_logo ?>"
                                 data-logo-alt="<?= $url_logo ?>"
                                 class="img-responsive"
                                 alt="Logo da empresa">
                            <h3><span class="colored"><?= $nome_fantasia ?></span></h3>
                            <span><?= $nome_fantasia ?></span>
                        </a>-->


                        </div><!-- .col-md-12 end -->
                    </div><!-- .row end -->
                </div><!-- .container end -->

            </div><!-- #header-wrap end -->

        </header><!-- #header end -->


        <!-- Banner
    ============================================= -->
        <section id="banner" data-scroll-index="0">

            <div class="banner-parallax">
                <img class="img-responsive card-img-top" src="<?= $url_foto_principal ?>" alt="Foto grande ao fundo da página">
                <div class="overlay-colored" data-bg-color="#000" data-bg-color-opacity="0.65"></div>
                <!-- .overlay-colored end -->
                <div class="slide-content">

                    <div class="container">
                        <div class="row">
                            <div class="col-md-8">

                                <div class="banner-center-box text-white">
                                    <h1><?= $marca ?> <?= $modelo ?></h1>
                                    <div class="description">
                                        <?php if (empty($complemento)) : ?>
                                        Oferta imperdivel!!!
                                        <?php else : ?>
                                        <?= $complemento ?>
                                        <?php endif; ?>
                                    </div>
                                    <?php if((alt_get_valor_promocional($post_id)) != false) :  ?>
                                    <div class="price">
                                        <span class="preco_veiculo">
                                            <?php echo 'De ' . get_preco_veiculo($post_id); ?>
                                        </span>
                                        <br>
                                        <span class="preco_promocional">
                                            <?php echo 'Por: ' . alt_get_valor_promocional($post_id) ?>
                                        </span>
                                    </div>
                                    <?php else : ?>


                                    <div class="price">
                                        <?php echo get_preco_veiculo($post_id); ?>
                                    </div>
                                    <?php endif ?>
                                    <?php if (!empty($url_telefone)) : ?>
                                    <a class="scroll-to btn xx-large colorful hover-dark mt-30 btn-telefone-action"
                                        href="<?= $url_telefone ?>">
                                        <i class="fa fa-phone"></i> Ligue agora!
                                    </a>
                                    <?php endif; ?>


                                    <?php if (!empty($url_whatsapp)) : ?>
                                    <!-- Button trigger modal -->
                                    <a href="#whatsapp" id="open_modal" data-toggle="modal" data-target="#modelId"
                                        class="btn xx-large hover-whatsapp mt-30">
                                        <i class="alt-icon-whatsapp2"></i> Whatsapp
                                    </a>
                                    <?php endif; ?>
                                </div><!-- .banner-center-box end -->

                            </div><!-- .col-md-10 end -->
                            <div class="col-md-4">

                            </div>
                        </div><!-- .row end -->
                    </div><!-- .container end -->

                </div><!-- .slide-content end -->
            </div><!-- .banner-parallax end -->

        </section><!-- #banner end -->


        <?php if (count($lista_imagens) > 0) : ?>

        <section id="fotos">

            <div class="owl-carousel owl-themex">
                <?php foreach ($lista_imagens as $images) : ?>

                <div class="item">
                    <a class="lightbox-img" href="<?= $images["src"] ?>">
                        <img class="owl-lazy" data-src="<?= $images["src"] ?>" alt="Imagem de um veículo "
                            src="<?= $images["src"] ?>" />
                    </a>
                </div>


                <?php endforeach; ?>

            </div>


        </section>
        <div class="arrow-down"></div>
        <?php endif; ?>
        <!-- Content
    ============================================= -->
        <section id="content">

            <div id="content-wrap">


                <!-- === Our Services =========== -->
                <div id="fale-conosco" class="flat-section center-vertical" data-scroll-index="1">

                    <div class="section-content">


                        <div class="container">
                            <div class="row">
                                <div class="col-md-6">

                                    <div class="row">
                                        <div class="col-md-12">

                                            <div class="section-title">
                                                <h2>
                                                    <?= $titulo ?>
                                                </h2>
                                                <p>
                                                    Uma oferta incrível esperando por você!As
                                                    melhores oportunidades você encontra aqui. Fale com um dos nossos
                                                    consultores agora mesmo e tire todas
                                                    suas dúvidas e feche o melhor negócio.
                                                </p>
                                            </div><!-- .section-title end -->

                                        </div>
                                    </div>


                                    <div class="row">

                                        <div class="box-infos">
                                            <?php if (!empty($quilometragem)) : ?>
                                            <div class="col-md-6">
                                                <div class="box-info mb-60">
                                                    <div class="box-icon icon x2 colorful-icon mr-20">
                                                        <span class="alt-icon-miles"></span>
                                                    </div>
                                                    <div class="box-content">
                                                        <h4>Quilometragem</h4>
                                                        <p>
                                                            <?= $quilometragem ?>
                                                        </p>
                                                    </div><!-- .box-content end -->
                                                </div><!-- .box-info end -->
                                            </div>
                                            <?php endif; ?>


                                            <?php if (!empty($ano_modelo)) : ?>
                                            <div class="col-md-6">
                                                <div class="box-info mb-60">
                                                    <div class="box-icon icon x2 colorful-icon mr-20">
                                                        <span class="alt-icon-year"></span>
                                                    </div>
                                                    <div class="box-content">
                                                        <h4>Ano/Modelo</h4>
                                                        <p>
                                                            <?= $ano_modelo ?>
                                                        </p>
                                                    </div><!-- .box-content end -->
                                                </div><!-- .box-info end -->
                                            </div>
                                            <?php endif; ?>


                                            <?php if (!empty($cambio)) : ?>
                                            <div class="col-md-6">
                                                <div class="box-info mb-60">
                                                    <div class="box-icon icon x2 colorful-icon mr-20">
                                                        <span class="alt-icon-transmission"></span>
                                                    </div>
                                                    <div class="box-content">
                                                        <h4>Câmbio</h4>
                                                        <p class="letra-maiuscula">
                                                            <?= $cambio ?>
                                                        </p>
                                                    </div><!-- .box-content end -->
                                                </div><!-- .box-info end -->
                                            </div>
                                            <?php endif; ?>


                                            <?php if (!empty($combustivel)) : ?>
                                            <div class="col-md-6">
                                                <div class="box-info  mb-60">
                                                    <div class="box-icon icon x2 colorful-icon mr-20">
                                                        <span class="alt-icon-combustivel1"></span>
                                                    </div>
                                                    <div class="box-content">
                                                        <h4>Combustível</h4>
                                                        <p>
                                                            <?= $combustivel ?>
                                                        </p>
                                                    </div><!-- .box-content end -->
                                                </div><!-- .box-info-1 end -->
                                            </div>
                                            <?php endif; ?>


                                            <?php if (!empty($portas)) : ?>
                                            <div class="col-md-6">
                                                <div class="box-info  mb-60">
                                                    <div class="box-icon icon x2 colorful-icon mr-20">
                                                        <span class="icon-car-door"></span>
                                                    </div>
                                                    <div class="box-content">
                                                        <h4>Portas</h4>
                                                        <p>
                                                            <?= $portas ?>
                                                        </p>
                                                    </div><!-- .box-content end -->
                                                </div><!-- .box-info-1 end -->
                                            </div>
                                            <?php endif; ?>

                                            <?php if (!empty($cor)) : ?>
                                            <div class="col-md-6">
                                                <div class="box-info  mb-60">
                                                    <div class="box-icon icon x2 colorful-icon mr-20">
                                                        <span class="alt-icon-color"></span>
                                                    </div>
                                                    <div class="box-content">
                                                        <h4>Cor</h4>
                                                        <p>
                                                            <?= $cor ?>
                                                        </p>
                                                    </div><!-- .box-content end -->
                                                </div><!-- .box-info-1 end -->
                                            </div>
                                            <?php endif; ?>

                                        </div>


                                    </div><!-- .box-center end -->


                                    <?if (count($arrOpcionais) > 0) : ?>
                                        <div class="row" id="opcionais">
                                            <div class="box-opcionais">
                                                <?php foreach ($arrOpcionais as $dados) : ?>
                                                    <div class="col-md-6">

                                                        <span class="fa fa-check"></span>
                                                        <?= $dados['descricao']; ?>
                                                    </div>
                                                <?php endforeach; ?>
                                            </div>
                                            <?php if (count($arrOpcionais) > 8) : ?>
                                                <div class="box-opcionais-more">
                                                    <div class="row">
                                                        <div class="col-md-12 text-center">
                                                            <span class="btn-more">Exibir mais</span>
                                                        </div>
                                                    </div>
                                                </div>
                                            <?php endif; ?>
                                        </div>
                                    <? endif; ?>


                                    <div class="row">

                                        <div class="col-md-12">
                                            <div class="box-observacoes mb-60 pt-30">
                                                <p>
                                                    <?= the_content() ?>
                                                </p>
                                            </div>
                                        </div>
                                    </div>


                                </div><!-- .col-md-6 end -->
                                <div class="col-md-5 col-md-offset-1">

                                    <div class="box-cta">
                                        <div class="register-house box-form text-center">
                                            <div class="box-title">
                                                <i class="rh-arrow fa fa-angle-down"></i>
                                                <h4>Tire suas dúvidas<br />
                                                    Fale conosco agora mesmo</h4>
                                            </div><!-- .box-title end -->
                                            <div class="box-content">

                                                <?php if (is_active_sidebar('alt_sidebar_lp')) : ?>
                                                <?php dynamic_sidebar('alt_sidebar_lp'); ?>
                                                <?php else : ?>
                                                <?php if (!empty($url_telefone)) : ?>
                                                <div class="call_to_now">
                                                    <a id="open_phone" href="<?= $url_telefone ?>"
                                                        class="btn-cta btn-block btn-call btn-telefone-action">
                                                        <i class="fa fa-phone"></i> LIGUE AGORA!
                                                    </a>
                                                </div>
                                                <?php endif; ?>

                                                <?php if (!empty($url_telefone) && !empty($url_whatsapp)) : ?>
                                                <div class="mb-30 mt-30" style="font-weight: 900;">
                                                    OU
                                                </div>
                                                <?php endif; ?>

                                                <?php if (!empty($url_whatsapp)) : ?>
                                                <!-- Button trigger modal -->
                                                <a href="#whatsapp" id="open_modal" data-toggle="modal"
                                                    data-target="#modelId" class="btn-cta btn-whatsapp">
                                                    <i class="alt-icon-whatsapp2"></i> Whatsapp
                                                </a>
                                                <?php endif; ?>


                                                <?php endif; ?>


                                            </div><!-- .box-content end -->
                                        </div><!-- .box-form end -->
                                    </div><!-- .box-center end -->

                                    <div class="session-logo">
                                        <?php if (!empty($contadores)) : ?>
                                        <div class="alerta-cta">
                                            <div>🚨 <strong>Não perca essa oportunidade</strong>.🔥
                                            </div>

                                            <div>
                                                Esse veículo já recebeu <strong><?= $contadores ?>
                                                    visualizações</strong> de pessoas interessadas nele! Fale conosco
                                                agora mesmo e não perca essa oportunidade.
                                            </div>

                                        </div>
                                        <?php endif; ?>
                                    </div>
                                    <?php foreach ($arrInfo as $filial) : ?>
                                    <?php

                                        $endereco_completo = $filial['endereco_completo'] ?? null;
                                        $url_endereco = 'https://www.google.com.br/maps/place/' . $endereco_completo;
                                        ?>
                                    <div class="session-address">
                                        <div class="box-icone">
                                            <i class="alt-icon-pinmap"></i>
                                        </div>
                                        <div class="box-address">
                                            <div class="title">
                                                Venha fazer uma visita
                                            </div>
                                            <div class="address">
                                                <a target="_blank" id="go_to_address" href="<?= $url_endereco ?>">
                                                    <?= $endereco_completo ?></a>
                                            </div>
                                        </div>

                                    </div>
                                    <?php endforeach; ?>


                                    <div class="mt-50" id="logo_loja">
                                        <img src="<?= $url_logo ?>" data-logo-alt="<?= $url_logo ?>"
                                            alt="<?= $nome_fantasia ?>" class="img-responsive" style="margin: auto;">
                                    </div>


                                </div><!-- .col-md-5 end -->
                            </div><!-- .row end -->
                        </div><!-- .container end -->

                    </div><!-- .section-content end -->

                </div><!-- .flat-section end -->

                <div class="container">
                    <?php if(alt_get_iframe_360($post->ID)) : ?>

                    <h3>Foto 360°</h3>
                    <iframe src="<?php echo alt_get_iframe_360($post->ID) . '/hideMenu' ?>" width="650" height="400"
                        style="border:0; margin-bottom: 30px;" allowfullscreen="" loading="lazy"
                        referrerpolicy="no-referrer-when-downgrade"></iframe>
                    <?php endif?>
                </div>
                <div id="intro-features" class="flat-section">

                    <div class="section-content">

                        <div class="container">
                            <div class="row">
                                <div class="col-md-6">

                                    <div class="box-info mb-md-50">
                                        <div class="box-icon icon x3 colorful-icon mr-20">
                                            <i class="alt-icon-bussiness"></i>
                                        </div>
                                        <div class="box-content">
                                            <h4>A certeza da melhor negociação</h4>
                                            <p>
                                                Venha fazer uma visita e conheça nosso estoque completo de
                                                veículos.<br />
                                                Diversas opções de <strong>financiamento</strong>.
                                            </p>
                                        </div><!-- .box-content end -->
                                    </div><!-- .box-info end -->

                                </div><!-- .col-md-6 end -->
                                <div class="col-md-6">

                                    <div class="box-info">
                                        <div class="box-icon icon x3 colorful-icon mr-20">
                                            <i class="fa fa-car"></i>
                                        </div>
                                        <div class="box-content">
                                            <h4>Compramos seu veículo</h4>
                                            <p>
                                                Aceitamos seu carro antigo como entrada.
                                                Fale agora mesmo com nossos consultores e <strong>solicite uma
                                                    avaliação.</strong>
                                            </p>
                                        </div><!-- .box-content end -->
                                    </div><!-- .box-info end -->

                                </div><!-- .col-md-6 end -->
                            </div><!-- .row end -->
                        </div><!-- .container end -->

                    </div><!-- .section-content end -->

                </div>

                <div class="arrow-down"></div>

                <?php if (!empty($arrVeiculos)) : ?>
                <!-- === Featured Houses =========== -->
                <div id="xfeatured-houses" class="flat-section" data-scroll-index="2">

                    <div class="section-content">

                        <div class="container">
                            <div class="row">
                                <div class="col-md-8 col-md-offset-2">

                                    <div class="section-title text-center">
                                        <h2>Confira outras <br />ofertas semelhantes</h2>
                                        <p>
                                            Venha fazer uma visita em nossa loja
                                            <br>
                                            <?= $endereco_completo ?>
                                        </p>
                                    </div><!-- .section-title end -->

                                </div><!-- .col-md-8 end -->
                                <div class="col-md-12">

                                    <div class="slider-project-house">
                                        <ul class="owl-carousel">
                                            <?php foreach ($arrVeiculos as $veiculo) : ?>
                                            <li>
                                                <div class="slide">
                                                    <div class="box-preview box-project-house">
                                                        <div class="box-img img-bg">
                                                            <a href="<?= get_permalink($veiculo->ID) ?>">
                                                                <?= get_alt_imagem_veiculo($veiculo->ID, 'medium', ['class' => 'img-responsive card-img-top']) ?>
                                                            </a>
                                                        </div><!-- .box-img end -->
                                                        <div class="box-content">
                                                            <h4>
                                                                <a href="<?= get_permalink($veiculo->ID) ?>">
                                                                    <?= get_titulo_produto($veiculo->ID); ?>
                                                                </a>
                                                            </h4>
                                                            <span class="price">
                                                                <?php echo get_preco_veiculo($veiculo->ID); ?>
                                                            </span>
                                                        </div><!-- .box-content end -->
                                                    </div><!-- .box-preview end -->
                                                </div><!-- .slide end -->
                                            </li>
                                            <?php endforeach; ?>
                                        </ul>
                                    </div><!-- .slider-project-house end -->

                                </div><!-- .col-md-12 end -->
                            </div><!-- .row end -->
                        </div><!-- .container end -->

                    </div><!-- .section-content end -->

                </div><!-- .flat-section end -->

                <div class="arrow-down"></div>
                <?php endif; ?>
                <?php if (!empty($youtube)) : ?>
                <!-- === Watch Video =========== -->
                <div id="watch-video" class="flat-section" data-scroll-index="2">

                    <div class="section-content">

                        <div class="container">
                            <div class="row">
                                <div class="col-md-8 col-md-offset-2">

                                    <div class="section-title text-center">
                                        <h2>Vídeo</h2>

                                    </div><!-- .section-title end -->

                                </div><!-- .col-md-8 end -->
                                <div class="col-md-10 col-md-offset-1">

                                    <div class="video-preview">
                                        <?= $youtube ?>
                                    </div>

                                </div><!-- .col-md-10 end -->
                            </div><!-- .row end -->
                        </div><!-- .container end -->

                    </div><!-- .section-content end -->

                </div><!-- .flat-section end -->

                <div class="arrow-down"></div>
                <?php endif; ?>
                <?php if (!empty($arrDepoimentos)) : ?>
                <!-- === Clients Testimonials =========== -->
                <div id="clients-testimonials" class="flat-section" data-scroll-index="2">

                    <div class="section-content">

                        <div class="container">
                            <div class="row">
                                <div class="col-md-8 col-md-offset-2">

                                    <div class="section-title text-center">
                                        <h2>
                                            Faça como outras centenas de clientes
                                            <br>
                                            Surpreenda-se!
                                        </h2>
                                        <p>
                                            Nosso compromisso é entregar para você o melhor veículo de acordo com
                                            suas
                                            necessidades.
                                            <br />
                                            Fale agora mesmo com um dos nossos vendedores!
                                        </p>
                                    </div><!-- .section-title end -->

                                </div><!-- .col-md-8 end -->
                                <div class="col-md-12">

                                    <div class="slider-testimonials">
                                        <ul class="owl-carousel">
                                            <?php foreach ($arrDepoimentos as $depoimento) : ?>
                                            <li>
                                                <div class="slide">
                                                    <div class="testimonial-single-1">
                                                        <div class="ts-content">
                                                            <span class="quote-sign">“</span>
                                                            “<?= $depoimento['content'] ?>”
                                                        </div><!-- .ts-content end -->
                                                        <div class="ts-person">
                                                            <div class="ts-img">
                                                                <img src="<?= $depoimento['foto'] ?>"
                                                                    alt="Foto do cliente <?= $depoimento['nome'] ?>">
                                                            </div><!-- .ts-img end -->
                                                            <h5><?= $depoimento['nome'] ?></h5>
                                                            <span><?= $depoimento['cargo'] ?></span>
                                                        </div><!-- .ts-person end -->
                                                    </div><!-- .testimonial-single-1 -->
                                                </div><!-- .slide end -->
                                            </li>
                                            <?php endforeach; ?>

                                        </ul>
                                    </div><!-- .slider-testimonials end -->

                                </div><!-- .col-md-12 end -->
                            </div><!-- .row end -->
                        </div><!-- .container end -->

                    </div><!-- .section-content end -->

                </div><!-- .flat-section end -->

                <?php endif; ?>
                <!-- === CTA Title 1 =========== -->
                <div id="cta-title-1" class="parallax-section text-white" data-bg-img="img-2.jpg"
                    data-stellar-background-ratio="0.2">

                    <div class="overlay-colored" data-bg-color="#000" data-bg-color-opacity="0.7"></div>
                    <!-- .overlay-colored end -->
                    <div class="section-content">

                        <div class="container">
                            <div class="row">
                                <div class="col-md-12">
                                    <!--<img src="<?= $url_logo ?>" data-logo-alt="<?= $url_logo ?>"
                                     alt="<?= $nome_fantasia ?>" class="img-responsive" style="margin: auto;">-->
                                </div>
                                <div class="col-md-12 text-center">

                                    <h1>O que você está esperando?</h1>
                                    <p>
                                        Fale agora mesmo com nossos especialistas
                                        <br>
                                        Temos a garantia do melhor negócio!
                                    </p>
                                    <?php if (!empty($url_telefone)) : ?>
                                    <a class="scroll-to btn xx-large colorful hover-dark mt-30 btn-telefone-action"
                                        href="<?= $url_telefone ?>">
                                        <i class="fa fa-phone"></i> Ligue agora!
                                    </a>
                                    <?php endif; ?>


                                    <?php if (!empty($url_whatsapp)) : ?>
                                    <!-- Button trigger modal -->
                                    <a href="#whatsapp" id="open_modal" data-toggle="modal" data-target="#modelId"
                                        class="btn xx-large hover-whatsapp mt-30">
                                        <i class="alt-icon-whatsapp2"></i> Whatsapp
                                    </a>
                                    <?php endif; ?>

                                </div><!-- .col-md-12 end -->
                            </div><!-- .row end -->
                        </div><!-- .container end -->

                    </div><!-- .section-content end -->

                    <!-- Footer Mini
                ============================================= -->
                    <footer id="footer-mini">

                        <div class="container">
                            <div class="row">
                                <div class="col-xs-12 text-center">

                                    <div class="copyrights-message text-white">
                                        <a href="https://www.altimus.com.br" rel="noreferrer" target="_blank">
                                            <img src="https://cdn-wp-altimus.s3-sa-east-1.amazonaws.com/imagens/logo-horizontal-color.png"
                                                alt="logo da empresa Altimus, responsável pelo desenvolvimento do site"
                                                class="img-responsive" style="margin: auto;" />
                                        </a>
                                    </div>

                                </div><!-- .col-md-12 end -->
                            </div><!-- .row end -->
                        </div><!-- .container end -->

                    </footer><!-- #footer-mini end -->

                </div><!-- .parallax-section end -->

            </div><!-- #content-wrap -->

        </section><!-- #content end -->

    </div><!-- #full-container end -->

    <a class="scroll-top-icon scroll-top" href="#"><i class="fa fa-angle-up"></i></a>
    <?php wp_footer(); ?>
    <!-- External JavaScripts
============================================= -->
    <script>
                /**
         * Verifica se a imagem na URL informada existe.
         * @param {string} url - URL da imagem a ser verificada.
         * @returns {Promise<boolean>} - Promise que resolve para true se a imagem existir, ou false se não existir.
         */
        function imagemExiste(url) {
            return new Promise((resolve) => {
                if (!url) {
                    resolve(false);
                    return;
                }
                const testImg = new Image();
                testImg.onload = function() {
                    resolve(true);
                };
                testImg.onerror = function() {
                    resolve(false);
                };
                testImg.src = url;
            });
        }
        
        /**
         * Seleciona todas as imagens dentro dos elementos com a classe "lightbox-img",
         * valida se a imagem existe e, caso não exista, remove o elemento pai com a classe "owl-item".
         */
        function removeOwlItemsWithLightboxImages() {
            // Seleciona todas as imagens dentro de elementos com a classe "lightbox-img"
            const images = document.querySelectorAll('.lightbox-img img');
            
            images.forEach(img => {
                const src = img.getAttribute('src');
                imagemExiste(src).then(exists => {
                    if (!exists) {
                        // Procura o ancestral com a classe "owl-item"
                        const owlItem = img.closest('.owl-item');
                        if (owlItem) {
                            owlItem.remove();
                        }
                    }
                });
            });
        }
        
        // Exemplo de uso: garantir que a função seja chamada após a inicialização do Owl Carousel ou ao final do carregamento da página.
        document.addEventListener('DOMContentLoaded', function() {
            // Chamada com pequeno delay para garantir que o DOM esteja completamente carregado
            removeOwlItemsWithLightboxImages();
        });
    </script>
    <script src="<?= $url_files ?>js/jquery.js"></script>
    <script src="<?= $url_files ?>js/bootstrap.min.js"></script>
    <script src="<?= $url_files ?>js/jRespond.min.js"></script>
    <script src="<?= $url_files ?>js/jquery.easing.min.js"></script>
    <script src="<?= $url_files ?>js/jquery.waitforimages.min.js"></script>
    <script src="<?= $url_files ?>js/jquery.fitvids.js"></script>
    <script src="<?= $url_files ?>js/jquery.waypoints.min.js"></script>
    <script src="<?= $url_files ?>js/jquery.stellar.js"></script>
    <script src="<?= $url_files ?>js/owl.carousel.min.js"></script>
    <script src="<?= $url_files ?>js/jquery.mb.YTPlayer.min.js"></script>
    <script src="<?= $url_files ?>js/hoverIntent.js"></script>
    <script src="<?= $url_files ?>js/simple-scrollbar.min.js"></script>
    <script src="<?= $url_files ?>js/superfish.js"></script>
    <script src="<?= $url_files ?>js/scrollIt.min.js"></script>
    <script src="<?= $url_files ?>js/jquery.pointpoint.js"></script>
    <script src="<?= $url_files ?>js/jquery.magnific-popup.min.js"></script>
    <script src="<?= $url_files ?>js/jquery.validate.min.js"></script>
    <script src='<?= $url_files ?>js/lp.js?<?= date('Ymd') ?>'></script>
    <script>
    jQuery(document).ready(function($) {


        $('.btn-more').on('click', function(e) {
            //alert('teste');
            $('.box-opcionais').css('max-height', 'none')
            $('.btn-more').css('display', 'none');
        })


        $('#go_to_address').on('click', function(e) {
            window.dataLayer = window.dataLayer || [];
            window.dataLayer.push({
                'event': 'Altimus',
                'eventCategory': 'LP',
                'eventAction': 'VISITA',
                'eventLabel': '<?= $titulo ?>',
                'eventValue': '<?= $preco ?>'
            });
        });


        $('.btn-telefone-action').on('click', function(e) {
            window.dataLayer = window.dataLayer || [];
            window.dataLayer.push({
                'event': 'Altimus',
                'eventCategory': 'LP',
                'eventAction': 'LIGAÇOES',
                'eventLabel': '<?= $titulo ?>',
                'eventValue': '<?= $preco ?>'
            });
        });

        $('#novo_btn_whatsapp_modal').on('click', function(e) {
            window.dataLayer = window.dataLayer || [];
            window.dataLayer.push({
                'event': 'Altimus',
                'eventCategory': 'LP',
                'eventAction': 'WHATSAPP',
                'eventLabel': '<?= $titulo ?>',
                'eventValue': '<?= $preco ?>'
            });


        })
    });
    </script>
</body>

</html>