<?php

if (!function_exists('lgpd_modal')) {

    if (get_modal_lgpd()) {

        $exist = get_page_by_path('politica-de-privacidade');


        if (!empty($exist)) {
            add_action('after_body_open_tag', 'lgpd_modal');
        };


    }

    function lgpd_modal()
    {
        ?>


        <style>
            #aviso_lgpd {
                position: fixed;
                bottom: 0px;
                width: 20%;
                min-height: 50px;
                z-index: 999;
                margin-bottom: 0px;
                color: #efefef;
                background-color: #080808cc;
                border-color: #ebccd1;
                text-align: left;
                padding: 20px;
                display: none;
            }

            #aviso_lgpd a {
                color: #fff;
                font-weight: 800;
            }

            #aviso_lgpd .btn {
                padding: 5px;
            }

            #aviso_lgpd .btn-primary {
                border: 1px solid #fff;;
            }

            #aviso_lgpd .btn-primary:hover{
                background: black;
            }

            #aviso_lgpd .btn-danger {
                border: 1px solid #fff;;
            }

            @media only screen and (max-width: 765px) {
                #aviso_lgpd {
                    width: 100%;
                }
            }

            #aviso_lgpd .botoes_lgpd .btn{
                float: right;
                margin-right: 5px;
            }
        </style>

        <div id="aviso_lgpd">
            Usamos os cookies e dados de navegação visando proporcionar uma melhor experiência durante o uso do site.
            Ao continuar, você concorda com nossa  <a href="/politica-de-privacidade">Política de Privacidade.</a>
            <br/>
            <br/>
            <div class="botoes_lgpd">
                <a href="javascript:aceitarLGPD()" class="btn btn-primary">Fechar</a>

            </div>
        </div>

        <script>

            function checkCookie() {

                let val_lgpd = getCookie("LGDP");
                if (val_lgpd == "true") {
                    document.getElementById("aviso_lgpd").remove();
                } else {

                    document.getElementById("aviso_lgpd").style.display = 'block';
                }
            }


            function setCookie(cname, cvalue, exdays) {
                var d = new Date();
                d.setTime(d.getTime() + (exdays * 24 * 60 * 60 * 1000));
                var expires = "expires=" + d.toGMTString();
                document.cookie = cname + "=" + cvalue + ";" + expires + ";path=/";
            }

            function getCookie(cname) {
                var name = cname + "=";
                var decodedCookie = decodeURIComponent(document.cookie);
                var ca = decodedCookie.split(';');
                for (var i = 0; i < ca.length; i++) {
                    var c = ca[i];
                    while (c.charAt(0) == ' ') {
                        c = c.substring(1);
                    }
                    if (c.indexOf(name) == 0) {
                        return c.substring(name.length, c.length);
                    }
                }
                return "";
            }

            function aceitarLGPD() {

                setCookie('LGDP', true, 999)
                document.getElementById("aviso_lgpd").remove();

            }

            function rejeitarLGPD() {
                setCookie('LGDP', true, 30);
                document.getElementById("aviso_lgpd").remove();
            }

            checkCookie();
        </script>
        <?php
    }


}
