<?php

if (!defined('ABSPATH')) {
    define('ABSPATH', dirname(__FILE__) . '/');
}

// Incluindo os arquivos necessários
require_once ABSPATH . 'wp-content/plugins/wordpress-importer/class-wp-import.php';
require_once ABSPATH . 'wp-content/plugins/wordpress-importer/parsers/class-wxr-parser.php';
require_once ABSPATH . 'wp-content/plugins/wordpress-importer/parsers/class-wxr-parser-simplexml.php';

class WP_importer
{
    public function __construct()
    {
        $this->main();
    }

    /**
     * Função principal que realiza a importação dos dados do XML.
     */
    public function main()
    {
        $data = plugin_dir_path(__FILE__) . 'altimus-formulario.xml';
        $file = file_get_contents($data);
        $xml = simplexml_load_string($file);
        $size = count($xml->channel->item);
        $hasData = false;
        $author_id = get_users(array('number' => 1))[0]->ID;

        if ($size > 0) {
            $hasData = true;
        }

        if ($hasData) {
            foreach ($xml->channel->item as $item) {
                $postCreated = array(
                    'post_title' => (string)$item->title,
                    'post_content' => (string)$item->children('content', true)->encoded,
                    'post_excerpt' => (string)$item->children('excerpt', true)->encoded,
                    'post_status' => 'publish',
                    'ping_status' => 'closed',
                    'post_author' => $author_id,
                    'post_type' => 'wpcf7_contact_form'
                );

                $existing_post = get_posts(array(
                    'post_type' => 'wpcf7_contact_form',
                    'title' => $postCreated['post_title'],
                    'post_status' => 'any',
                    'numberposts' => 1
                ));

                $existing_post = !empty($existing_post) ? $existing_post[0] : null;

                if (!$existing_post) {
                    $result = wp_insert_post($postCreated);

                    if ($result > 0) {
                        $inserted_post_id = $result;

                        // Adicionar metadados padrão
                        foreach ($item->children('wp', true)->postmeta as $meta) {
                            $meta_key = (string)$meta->meta_key;
                            $meta_value = maybe_unserialize((string)$meta->meta_value);
                            add_post_meta($inserted_post_id, $meta_key, $meta_value);
                        }

                        // Tratar especificamente os campos '_mail', '_mail_2' e '_messages'
                        $specific_meta_keys = ['_mail', '_mail_2', '_messages'];
                        foreach ($specific_meta_keys as $meta_key) {
                            $meta_value = get_meta_value($item, $meta_key);
                            if ($meta_value !== null) {
                                update_post_meta($inserted_post_id, $meta_key, $meta_value);
                            }
                        }
                    } else {
                        error_log('Erro ao inserir o post: ' . print_r($postCreated, true));
                    }
                } else {
                    error_log('Post já existe: ' . $postCreated['post_title']);
                }
            }
        } else {
            error_log('Nenhum dado encontrado no XML.');
        }
    }
}

/**
 * Função para importar o XML.
 */
function ImportarXML()
{
    $data = plugin_dir_path(__FILE__) . 'formularios.xml';
    $obj = new WP_importer();
    $obj->main();
}

/**
 * Função para fazer o parse do arquivo usando o WXR_Parser.
 * @param string $file O caminho do arquivo XML.
 * @return mixed O resultado do parse.
 */
function parse($file)
{
    $parser = new WXR_Parser();
    return $parser->parse($file);
}

/**
 * Função para fazer o parse do arquivo usando o WXR_Parser_SimpleXML.
 * @param string $file O caminho do arquivo XML.
 * @return mixed O resultado do parse.
 */
function xmlparse($file)
{
    $parser = new WXR_Parser_SimpleXML();
    return $parser->parse($file);
}

/**
 * Obtém o valor de um metadado específico no XML.
 *
 * @param SimpleXMLElement $item Item do XML.
 * @param string $meta_key Chave do metadado.
 * @return mixed|null Valor do metadado ou null se não encontrado.
 */
function get_meta_value($item, $meta_key)
{
    foreach ($item->children('wp', true)->postmeta as $meta) {
        if ((string)$meta->meta_key === $meta_key) {
            return maybe_unserialize((string)$meta->meta_value);
        }
    }
    return null;
}