<?php

if (!defined('ABSPATH')) {
    define('ABSPATH', dirname(__FILE__) . '/');
}

// Incluindo os arquivos necessários
require_once ABSPATH . 'wp-content/plugins/wordpress-importer/class-wp-import.php';
require_once ABSPATH . 'wp-content/plugins/wordpress-importer/parsers/class-wxr-parser.php';
require_once ABSPATH . 'wp-content/plugins/wordpress-importer/parsers/class-wxr-parser-simplexml.php';

class WP_Page_Importer
{
    public function __construct()
    {
        $this->importPages();
    }

    /**
     * Função para realizar a importação de páginas do XML.
     */
    public function importPages()
    {
        // Caminho para o arquivo XML
        $data = plugin_dir_path(__FILE__) . 'altimus-paginas-portal.xml';

        // Carregar o conteúdo do arquivo XML
        $file = file_get_contents($data);
        $xml = simplexml_load_string($file);

        // Obter o ID do autor/admin
        $author_id = get_users(array('number' => 1))[0]->ID;

        // Verificar se há itens para importar
        if (isset($xml->channel->item)) {
            foreach ($xml->channel->item as $item) {
                if ((string)$item->children('wp', true)->post_type !== 'page') {
                    continue;
                }

                // Criar um array com os dados da página
                $pageData = array(
                    'post_title' => (string)$item->title,
                    'post_content' => (string)$item->children('content', true)->encoded,
                    'post_status' => (string)$item->children('wp', true)->status,
                    'post_author' => $author_id,
                    'post_type' => 'page',
                    'post_name' => (string)$item->children('wp', true)->post_name
                );

                // Verificar se a página já existe
                $existing_page = get_posts(array(
                    'post_type' => 'page',
                    'name' => $pageData['post_name'],
                    'post_status' => 'any',
                    'numberposts' => 1
                ));

                if (!$existing_page) {
                    // Inserir a página no banco de dados
                    $result = wp_insert_post($pageData);

                    if ($result > 0) {
                        $inserted_page_id = $result;

                        // Adicionar metadados da página
                        foreach ($item->children('wp', true)->postmeta as $meta) {
                            $meta_key = (string)$meta->meta_key;
                            $meta_value = (string)$meta->meta_value;
                            add_post_meta($inserted_page_id, $meta_key, $meta_value);
                        }
                    } else {
                        error_log('Erro ao inserir a página: ' . print_r($pageData, true));
                    }
                } else {
                    error_log('Página já existe: ' . $pageData['post_title']);
                }
            }
        } else {
            error_log('Nenhum dado encontrado no XML.');
        }
    }
}

/**
 * Função para iniciar a importação das páginas.
 */
function ImportarPaginasXML()
{
    $importer = new WP_Page_Importer();
    $importer->importPages();
}
