<?php

add_action('init', 'remove_select_image_sizes');


function remove_select_image_sizes()
{
    foreach (get_intermediate_image_sizes() as $size) {
        if (!in_array($size, array('large', 'medium_large', 'medium'))) {
            remove_image_size($size);
        }
    }

    add_image_size('large', 1920, 1440, false);
    add_image_size('medium_large', 1024, 768, false);
    add_image_size('medium', 768, 576, false);
    add_image_size('thumbnail', 450, 337, false);
}

define('ALT_IMAGE_MINI', '(max-width: 150px) 100vw, 150px');
define('ALT_IMAGE_SMALL', '(max-width: 300px) 100vw, 300px');
define('ALT_IMAGE_MEDIUM', '(max-width: 600px) 100vw, 600px');