<?php

add_action('wp_ajax_fotos_nao_usadas', 'excluir_fotos_nao_usadas');
//do_action('excluir_fotos_nao_usadas');

function useRegex($input)
{
    $regex = '/[A-Za-z0-9]+_[0-9]+/i';
    return preg_match($regex, $input);
}

function excluir_fotos_nao_usadas()
{
    $limite_fotos = 500;
    $count_fotos_analisadas = 0;
    $arquivos_excluidos = [];

    $dados = get_option('alt_group_setup');

    $attachments = get_posts(array(
        'post_type' => 'attachment',
        'numberposts' => -1,
        'fields' => 'ids',
        'post_parent' => 0,
    ));



    if ($attachments) {
        foreach ($attachments as $attachmentID) {

            if ($attachmentID == $dados['logo_id']) {
                continue;
            }

            $attachment_path = get_attached_file($attachmentID);

            $info = useRegex($attachment_path);

            if ($info > 0) {

                //Delete attachment from database only, not file
                $delete_attachment = wp_delete_attachment($attachmentID, true);
                
                //Delete attachment file from disk
                if ($delete_attachment) {
                    $delete_file = unlink($attachment_path);
                }

                $arquivos_excluidos[] = $delete_attachment;

                if ($count_fotos_analisadas >= $limite_fotos) {
                    break; //se chegou no limite, para o processamento
                } else {
                    $count_fotos_analisadas++;
                }
            } else {
                continue;
            }
        }
    }

    pr($arquivos_excluidos);
    die;
}
