<?php

/**
 * Gera ícones dinâmicos com base no tipo de veículo.
 *
 * @param string $tipoVeiculo O tipo de veículo (por exemplo, 'lancha').
 * @return string O ícone SVG correspondente ao tipo de veículo.
 */
if (!function_exists('alt_icones_dinamicos')) {
    function alt_icones_dinamicos($tipoVeiculo)
    {
        $tipo = strtolower($tipoVeiculo);

        $icones = [
            'padrao' => '<svg width="34" height="30" viewBox="0 0 34 30" xmlns="http://www.w3.org/2000/svg">
                    <path d="M3.77778 11.25L6.61111 2.8125H27.3889L30.2222 11.25M27.3889 20.625C26.6374 20.625 25.9168 20.3287 25.3854 19.8012C24.8541 19.2738 24.5556 18.5584 24.5556 17.8125C24.5556 17.0666 24.8541 16.3512 25.3854 15.8238C25.9168 15.2963 26.6374 15 27.3889 15C28.1403 15 28.861 15.2963 29.3924 15.8238C29.9237 16.3512 30.2222 17.0666 30.2222 17.8125C30.2222 18.5584 29.9237 19.2738 29.3924 19.8012C28.861 20.3287 28.1403 20.625 27.3889 20.625ZM6.61111 20.625C5.85966 20.625 5.13899 20.3287 4.60764 19.8012C4.07629 19.2738 3.77778 18.5584 3.77778 17.8125C3.77778 17.0666 4.07629 16.3512 4.60764 15.8238C5.13899 15.2963 5.85966 15 6.61111 15C7.36256 15 8.08323 15.2963 8.61458 15.8238C9.14593 16.3512 9.44444 17.0666 9.44444 17.8125C9.44444 18.5584 9.14593 19.2738 8.61458 19.8012C8.08323 20.3287 7.36256 20.625 6.61111 20.625ZM30.0711 1.875C29.6933 0.7875 28.6356 0 27.3889 0H6.61111C5.36444 0 4.30667 0.7875 3.92889 1.875L0 13.125V28.125C0 28.6223 0.199007 29.0992 0.553243 29.4508C0.907478 29.8025 1.38792 30 1.88889 30H3.77778C4.27874 30 4.75919 29.8025 5.11342 29.4508C5.46766 29.0992 5.66667 28.6223 5.66667 28.125V26.25H28.3333V28.125C28.3333 28.6223 28.5323 29.0992 28.8866 29.4508C29.2408 29.8025 29.7213 30 30.2222 30H32.1111C32.6121 30 33.0925 29.8025 33.4468 29.4508C33.801 29.0992 34 28.6223 34 28.125V13.125L30.0711 1.875Z" />
                </svg>',
            'lancha' => '<svg width="38" height="38" viewBox="0 0 28 30" xmlns="http://www.w3.org/2000/svg">
                    <path d="M1.55296 30H0.338615V27H1.55296C2.76731 27 3.92473 26.8688 5.02523 26.6063C6.12573 26.3438 7.35905 25.925 8.72519 25.35C9.68654 25.825 10.5277 26.2188 11.2487 26.5312C11.9698 26.8438 12.8868 27 14 27C15.1131 27 16.0302 26.8438 16.7513 26.5312C17.4723 26.2188 18.3135 25.825 19.2748 25.35C20.6157 25.925 21.849 26.3438 22.9748 26.6063C24.1006 26.8688 25.2706 27 26.485 27H27.6614V30H26.485C25.2453 30 24.0373 29.8875 22.8609 29.6625C21.6845 29.4375 20.5271 29.1 19.3887 28.65C18.3767 29.125 17.4533 29.4625 16.6184 29.6625C15.7836 29.8625 14.9108 29.9625 14 29.9625C13.0892 29.9625 12.2228 29.8625 11.4005 29.6625C10.5783 29.4625 9.66125 29.125 8.64929 28.65C7.51084 29.1 6.35342 29.4375 5.17702 29.6625C4.00063 29.8875 2.7926 30 1.55296 30ZM14 24C12.4821 24 11.1539 23.5 10.0154 22.5L8.30776 21C7.62469 21.675 6.8594 22.25 6.01188 22.725C5.16437 23.2 4.25994 23.5375 3.29858 23.7375L0.0729775 13.5C-0.0535168 13.075 -0.0155685 12.6875 0.186822 12.3375C0.389213 11.9875 0.705449 11.75 1.13553 11.625L3.37448 11.025V6C3.37448 5.175 3.67174 4.46875 4.26626 3.88125C4.86079 3.29375 5.57548 3 6.41034 3H10.2052V0H17.7948V3H21.5897C22.4245 3 23.1392 3.29375 23.7337 3.88125C24.3283 4.46875 24.6255 5.175 24.6255 6V11.025L26.8645 11.625C27.2946 11.75 27.6108 11.9875 27.8132 12.3375C28.0156 12.6875 28.0535 13.075 27.927 13.5L24.7014 23.7375C23.7401 23.5375 22.8356 23.2 21.9881 22.725C21.1406 22.25 20.3753 21.675 19.6922 21L17.9846 22.5C16.8461 23.5 15.5179 24 14 24ZM6.41034 10.2375L14 8.25L21.5897 10.2375V6H6.41034V10.2375Z"/>
                </svg>',  
        ];
        return $tipo == 'lancha' ? $icones[$tipo] : $icones['padrao'];
    }
}