<?php

use function PHPSTORM_META\type;
use function Sodium\compare;

if (!function_exists('alt_lista_veiculos')) {

    add_action('alt_lista_veiculos', 'alt_lista_veiculos');
    function alt_lista_veiculos($limit = 999)
    {
        $busca = '';

        $paged = (get_query_var('paged')) ? get_query_var('paged') : 1;

        $limit_page = get_total_veiculo_no_estoque();

        if ($limit) {
            $limit_page = $limit;
        }

        $filtro_veiculos_ordenacao = alt_query_filtro_veiculos_ordenacao();
        $filtro_veiculos = alt_query_filtro_veiculos();
        $post_author = $filtro_veiculos['post_author'] ?? null;
        $lojas_inativas_ids = alt_get_usuarios_lojas_inativas() ?? [];
        
        // Criar o array de argumentos para a consulta
        $args = array(
            'posts_per_page' => $limit_page,
            'paged' => $paged,
            'post_type' => 'veiculos',
            'post_status' => array('publish'),
        );

        // Verificar se a busca textual foi feita
        if (isset($filtro_veiculos['busca'])) {
            $busca = $filtro_veiculos['busca'];
            unset($filtro_veiculos['busca']);
        }

        if (alt_is_portal()) {
            // Se existir o filtro por loja e a loja não estiver inativa
            if ($post_author && !in_array($post_author, $lojas_inativas_ids)) {
                error_log('primeira condição');
                $args['author'] = $post_author;
                unset($post_author);
                // Se exisitir lojas inativas
            } elseif (!empty($lojas_inativas_ids) && in_array($post_author, $lojas_inativas_ids)) {
                // Para todas as outras possibilidades
                error_log('segunda condição');
                $args = [];
            } else {
                error_log('outras condições');
                $args['author__not_in'] = $lojas_inativas_ids;
            }
        }
        
        // Adicionar filtros adicionais
        $args = array_merge($args, $filtro_veiculos_ordenacao, $filtro_veiculos);        
        
        // Criar a consulta
        $query = new WP_Query($args);
        
        $paginacao = array(
            'base' => str_replace(999999999, '%#%', esc_url(get_pagenum_link(999999999))),
            'total' => $query->max_num_pages,
            'current' => max(1, get_query_var('paged')),
            'format' => '?paged=%#%',
            'show_all' => true,
            'type' => 'array',
            'end_size' => 2,
            'mid_size' => 1,
            'prev_next' => false,
            'prev_text' => sprintf('<i></i> %1$s', 'Anterior'),
            'next_text' => sprintf('%1$s <i></i>', 'Próximo'),
            'add_args' => false,
            'add_fragment' => '',
            'total_results' => $query->found_posts
        );
        
        $posts = $query->posts;
        
        if (empty($posts) && !empty($busca) && function_exists('alt_busca_similaridade_ativada') && alt_busca_similaridade_ativada()) {
            $posts = alt_busca_veiculos_similaridade($busca);
        }

        $arrResult['paginacao'] = $paginacao;

        foreach ($posts as $post) {
            $arrData['objeto'] = $post;
            $arrData['id'] = $post->ID;
            $arrData['name'] = $post->post_title;
            $arrData['regular_price'] = get_post_meta($post->ID, 'alt_preco', true) ?? 0;
            $arrData['slug'] = get_permalink($post->ID);

            $obj_tipo = get_the_terms($post->ID, 'tipo');
            $arrData['tipo'] = $obj_tipo[0]->name ?? null;


            $objMarca = get_the_terms($post->ID, 'marca', true);
            $arrData['marca'] = $objMarca[0]->name ?? null;


            $objModelo = get_the_terms($post->ID, 'modelo');
            $arrData['modelo'] = $objModelo[0]->name ?? null;


            $objCarroceria = get_the_terms($post->ID, 'carroceria');
            $arrData['carroceria'] = $objCarroceria[0]->name ?? null;


            $arrData['description'] = $post->post_content;

            $arrData['imagem_principal'] = get_the_post_thumbnail_url($post->ID, 'full');


            $info = get_post_meta($post->ID);
            $info['alt_acessorios'] = get_post_meta($post->ID, 'alt_acessorios', true);
            unset($info['alt_imagens']);
            unset($info['_edit_lock']);
            unset($info['_edit_last']);
            unset($info['_thumbnail_id']);


            $arrData['meta_data'] = [];
            foreach ($info as $key => $meta) {


                $value = $meta[0] ?? '';
                if ($key == 'alt_acessorios') {

                    if (isset($meta)) {
                        continue;
                    };
                    foreach ($meta as $i => $acessorio) {
                        $value[] = $acessorio;
                    }
                    if (isset($value['descricao'])) {
                        unset($value['descricao']);
                    }
                }
                $save_meta['value'] = $value;
                $save_meta['key'] = $key;
                $arrData['meta_data'][] = $save_meta;
            }


            //Carregar Imagens
            $position = 0;
            $arrListImagens = get_post_meta($post->ID, 'alt_imagens', true);
            if (!empty($arrListImagens)) {
                $arrData['images'] = [];
                foreach ($arrListImagens as $imagens) {

                    $name = basename($imagens);

                    $save_img['src'] = $imagens;
                    $save_img['name'] = $name;
                    $save_img['alt'] = $name;
                    $save_img['position'] = $position;

                    $arrData['images'][] = $save_img;

                    $position++;
                }
            }


            $arrResult['veiculos'][] = $arrData;
        }

        wp_reset_postdata();

        wp_reset_query();

        return $arrResult;
    }
}


if (!function_exists('get_alt_veiculos_mais_procurados')) {

    add_action('get_alt_veiculos_mais_procurados', 'get_alt_veiculos_mais_procurados');

    function get_alt_veiculos_mais_procurados($total = 3)
    {

        $arr = array(
            'post_type' => 'veiculos',
            'post_status' => 'publish',
            'posts_per_page' => $total,
            'meta_key' => 'post_views_count',
            'orderby' => 'post_views_count',
            'order' => 'DESC'
        );

        $query = new WP_Query($arr);
        $arrVeiculos = $query->posts;
        return $arrVeiculos;
    }
}


if (!function_exists('alt_query_filtro_veiculos')) {
    add_action('alt_query_filtro_veiculos', 'alt_query_filtro_veiculos');
    function alt_query_filtro_veiculos()
    {
        foreach ($_GET as $key => $value) {
            if (empty($_GET[$key])) {
                unset($_GET[$key]);
            } elseif($key !== 'acessorios') {
                $_GET[$key] = htmlspecialchars($value);
            }
        }

        $meta_query = [];

        if (isset($_GET['loja'])) {
            $return['post_author'] = $_GET['loja'];
        }
        
        if (isset($_GET['destaque'])) {

            $meta_query[] = array(
                'key' => 'alt_destaque',
                'value' => 'on',
                'compare' => '='
            );
        }

        if (isset($_GET['idaltimus'])) {

            $meta_query[] = array(
                'key' => 'alt_id',
                'value' => 'on',
                'compare' => '='
            );
        }


        if (isset($_GET['carrozero'])) {

            $meta_query['relation'] = 'OR';
            $meta_query[] = array(
                'key' => 'alt_zerokm',
                'compare' => '=',
                'value' => 'on'
            );

            $meta_query[] = array(
                'key' => 'alt_zerokm',
                'compare' => '=',
                'value' => '1'
            );
        }


        if (isset($_GET['repasse'])) {
            $valor = $_GET['repasse'];


            if ($valor == 'off') {
                $meta_query['relation'] = 'OR';
                $meta_query[] = array(
                    'key' => 'alt_repasse',
                    'compare' => '=',
                    'value' => ''
                );
            } else {
                $meta_query['relation'] = 'OR';
                $meta_query[] = array(
                    'key' => 'alt_repasse',
                    'compare' => '=',
                    'value' => 'on'
                );

                $meta_query[] = array(
                    'key' => 'alt_repasse',
                    'compare' => '=',
                    'value' => '1'
                );
            }
        }

        if (isset($_GET['min_km'])) {
            $meta_query[] = array(
                'key' => 'alt_kilometragem',
                'value' => $_GET['min_km'],
                'compare' => '>=',
                'type' => 'NUMERIC'
            );
        }

        if (isset($_GET['max_km'])) {
            $meta_query[] = array(
                'key' => 'alt_kilometragem',
                'value' => $_GET['max_km'],
                'compare' => '<=',
                'type' => 'NUMERIC'
            );
        }


        if (isset($_GET['min_preco'])) {
            $meta_query[] = array(
                'key' => 'alt_preco',
                'value' => preg_replace("/[^0-9]/","",$_GET['min_preco']),
                'compare' => '>=',
                'type' => 'NUMERIC'
            );
        }

        if (isset($_GET['max_preco'])) {
            $meta_query[] = array(
                'key' => 'alt_preco',
                'value' => preg_replace("/[^0-9]/","",$_GET['max_preco']),
                'compare' => '<=',
                'type' => 'NUMERIC'
            );
        }

        if (isset($_GET['min_price'])) {
            $meta_query[] = array(
                'key' => 'alt_preco',
                'value' => preg_replace("/[^0-9]/","",$_GET['min_price']),
                'compare' => '>=',
                'type' => 'NUMERIC'
            );
        }

        if (isset($_GET['max_price'])) {
            $meta_query[] = array(
                'key' => 'alt_preco',
                'value' => preg_replace("/[^0-9]/","",$_GET['max_price']),
                'compare' => '<=',
                'type' => 'NUMERIC'
            );
        }


        if (isset($_GET['filial'])) {
            $meta_query[] = array(
                'key' => 'alt_localizacao',
                'value' => $_GET['filial'],
                'compare' => '=',

            );
        }

        if (!empty($_GET['ano'])) {
            $meta_query[] = array(
                'key' => 'alt_ano_mod',
                'value' => $_GET['ano'],
                'compare' => '=',

            );
        }


        if (isset($_GET['min_ano'])) {
            $meta_query[] = array(
                'key' => 'alt_ano_mod',
                'value' => $_GET['min_ano'],
                'compare' => '>=',
                'type' => 'NUMERIC'
            );
        }

        if (isset($_GET['max_ano'])) {
            $meta_query[] = array(
                'key' => 'alt_ano_mod',
                'value' => $_GET['max_ano'],
                'compare' => '<=',
                'type' => 'NUMERIC'
            );
        }


        if (isset($_GET['cambio']) && !empty($_GET['cambio'])) {
            $meta_query[] = array(
                'key' => 'alt_cambio',
                'value' => $_GET['cambio'],
                'compare' => 'LIKE',

            );
        }

        if (isset($_GET['combustivel'])) {
            $meta_query[] = array(
                'key' => 'alt_combustivel',
                'value' => (int) $_GET['combustivel'],
                'compare' => '=',

            );
        }

        // valida o estado do veículo
        if (isset($_GET['estado'])) {
            if ($_GET['estado'] === 'novo') {
                // Retorna veículos cujo meta alt_zerokm seja "on" ou "1"
                $meta_query[] = array(
                    'key'     => 'alt_zerokm',
                    'value'   => array('on', '1'),
                    'compare' => 'IN'
                );
            } elseif ($_GET['estado'] === 'seminovo') {
                // Retorna veículos que NÃO possuem o meta alt_zerokm
                $meta_query[] = array(
                    'key'     => 'alt_zerokm',
                    'compare' => 'NOT EXISTS'
                );
            }
            
        }

        if (isset($_GET['min_ano'])) {
            $meta_query[] = array(
                'key' => 'alt_ano_mod',
                'value' => $_GET['min_ano'],
                'compare' => '>=',
                'type' => 'NUMERIC'
            );
        }

        if (isset($_GET['max_ano'])) {
            $meta_query[] = array(
                'key' => 'alt_ano_mod',
                'value' => $_GET['max_ano'],
                'compare' => '<=',
                'type' => 'NUMERIC'
            );
        }


        if (isset($_GET['acessorios'])) {

            $arrFiltroAcessorios = $_GET['acessorios'];
            $meta_query['relation'] = 'OR';

            foreach ($arrFiltroAcessorios as $acessorio) {

                $meta_query[] = array(
                    'key' => 'alt_acessorios',
                    'value' => $acessorio,
                    'compare' => 'LIKE'
                );
            }
        }

        if (isset($_GET['veiculo_id'])) {
            $return['post__in'] = array($_GET['veiculo_id']);
        }

        $return['meta_query'] = $meta_query;

        if (!empty($_GET['carroceria'])) {
            $return['tax_query'][] = array(
                'taxonomy' => 'carroceria',
                'field' => 'slug',
                'terms' => $_GET['carroceria'],
            );
        }
        
        if (!empty($_GET['categoria'])) {
            $return['tax_query'][] = array(
                'taxonomy' => 'carroceria',
                'field' => 'slug',
                'terms' => $_GET['categoria'],
            );
        }

        if (!empty($_GET['tipo'])) {
            $return['tax_query'][] = array(
                'taxonomy' => 'tipo',
                'field' => 'slug',
                'terms' => $_GET['tipo'],
            );
        }

        if (!empty($_GET['marca'])) {
            $return['tax_query'][] = array(
                'taxonomy' => 'marca',
                'field' => 'slug',
                'terms' => $_GET['marca'],
            );
        }

        if (!empty($_GET['modelo'])) {
            $return['tax_query'][] = array(
                'taxonomy' => 'modelo',
                'field' => 'slug',
                'terms' => $_GET['modelo'],
            );
        }
        if (!empty($_GET['tipo'])) {
            $return['tax_query'][] = array(
                'taxonomy' => 'tipo',
                'field' => 'slug',
                'terms' => $_GET['tipo'],
            );
        }
        
        if (isset($_GET['veiculo'])) {
            $searchTerm = sanitize_text_field(wp_unslash($_GET['veiculo'] ?? ''));
            $return['s'] = $searchTerm;
            $return['busca'] = $searchTerm;
        }
        
        return $return;
    }
}

if (!function_exists('alt_query_filtro_veiculos_ordenacao')) {
    function alt_query_filtro_veiculos_ordenacao()
    {
        $type = get_ordenacao_padrao() ?? 'order_preco_desc';

        if (isset($_GET['orderby'])) {
            switch ($_GET['orderby']) {
                case 'order_destaque_desc':
                    $type = 'order_destaque_desc';
                    break;
                case 'mais_recentes':
                    $type = 'mais_recentes';
                    break;
                case 'order_preco_desc':
                    $type = 'order_preco_desc';
                    break;
                case 'order_preco_asc':
                    $type = 'order_preco_asc';
                    break;
                case 'order_ano_desc':
                    $type = 'order_ano_desc';
                    break;
                case 'order_ano_asc':
                    $type = 'order_ano_asc';
                    break;
            }
        }

        if ($type == 'order_destaque_desc') {
            return [
                'meta_key' => 'post_views_count',
                'orderby' => [
                    'meta_value_num' => 'DESC',
                    'ID' => 'ASC', // Adicionando ordenação secundária por ID
                ],
                'order' => 'desc'
            ];
        }

        if ($type == 'mais_recentes') {
            return [
                'orderby' => [
                    'ID' => 'DESC', // Ordena por ID, já evitando duplicidade
                ]
            ];
        }

        if ($type == 'order_preco_desc') {
            return [
                'meta_key' => 'alt_preco',
                'orderby' => [
                    'meta_value_num' => 'DESC', 
                    'ID' => 'ASC', // Ordenação secundária por ID
                ],
            ];
        }

        if ($type == 'order_preco_asc') {
            return [
                'meta_key' => 'alt_preco',
                'orderby' => [
                    'meta_value_num' => 'ASC', 
                    'ID' => 'ASC', // Ordenação secundária por ID
                ],
            ];
        }

        if ($type == 'order_ano_desc') {
            return [
                'meta_key' => 'alt_ano_mod',
                'orderby' => [
                    'meta_value_num' => 'DESC',
                    'ID' => 'ASC', // Ordenação secundária por ID
                ],
            ];
        }

        if ($type == 'order_ano_asc') {
            return [
                'meta_key' => 'alt_ano_mod',
                'orderby' => [
                    'meta_value_num' => 'ASC',
                    'ID' => 'ASC', // Ordenação secundária por ID
                ],
            ];
        }

        return [];
    }
}

if (!function_exists('alt_delete_veiculos')) {
    function alt_delete_veiculos($post_id)
    {

        $post = get_post($post_id);

        if (empty($post)) {
            return ['msg' => 'Veiculo não encontrado'];
        }

        wp_delete_attachment($post_id);

        if (empty($post)) {
            return ['msg' => 'Nenhum veiculo localizado'];
        };

        $arrImagens = alt_get_caracteristicas($post_id, 'alt_imagens');

        if ($arrImagens) :
            foreach ($arrImagens as $id => $attachment) :
                wp_delete_attachment($id, true);
                wp_delete_post($id, true);
            endforeach;
        endif;
        
        //A função limpeza de cache tem que ser executada antes das funções de excluir para que o post possa ser passado como parâmetro. 
        alt_limpeza_cache($post_id);

        wp_delete_attachment($post_id, true);
        wp_delete_post($post_id, true);

        return ['msg' => 'Removido com sucesso'];
    }
}

if (!function_exists('alt_editar_incluir_veiculo')) {
    function alt_editar_incluir_veiculo($request)
    {
        //Associar TAGS
        $arrayTags = [];

        $nome = $request['name'];
        $slug = $request['slug'];
        $description = $request['description'];
        $id = $request['id'];
        $copia_imagens = [];

        $my_post = array(
            'ID' => $id,
            'post_title' => wp_strip_all_tags($nome),
            'post_content' => $description,
            'post_type' => 'veiculos',
            'post_status' => 'publish',
            'post_author' => get_current_user_id()
        );

        if (empty($id)) {
            $post_id = wp_insert_post($my_post);
        } else {
            $post_id = $id;
            wp_update_post($my_post);
            
            $copia_imagens = get_post_meta($post_id, 'alt_imagens', true);
        }
        // Remove todas as meta_values
        try {
            $meta_values = get_post_meta($post_id);
            if (!empty($meta_values)) {
                foreach ($meta_values as $meta_key => $meta_value) {
                    delete_post_meta($post_id, $meta_key);
                }
            }
        } catch (Exception $e) {
            error_log('Erro ao remover meta_values: ' . $e->getMessage());
        }

        /**
         * Associar meta dados
         */
        foreach ($request['meta_data'] as $data) {

            $valor = $data['value'] ?? '';
            $chave = $data['key'];

            if($chave == 'alt_envia_km'){
                $valor = $valor == '1' ? 1 : 0;
            }

            if (!add_post_meta($post_id, $chave, $valor, true)) {
                update_post_meta($post_id, $chave, $valor);
            }

            /**
             * Enviando as imagens foto_destaque para a tabela queue
             */
            if ($chave == 'foto_destaque') {
                alt_insert_queue_car_images($post_id, array(['src' => $valor]), 'foto_destaque');
            }
        
            //Associar TAGS
            if ($chave == 'tag_unico_dono' && $valor == "1") {
                $arrayTags[] = 'unico_dono';
            }

            if ($chave == 'tag_garantia' && $valor == "1") {
                $arrayTags[] = 'garantia';
            }

            if ($chave == 'tag-baixa_km' && $valor == "1") {
                $arrayTags[] = 'baixa_km';
            }
        }

        //Atualizar TAGS
        if (!empty($arrayTags)) {
            if (!add_post_meta($post_id, 'alt_tags', implode($arrayTags, ','), true)) {
                $currentTags = get_post_meta($post_id, 'alt_tags', true);
                $totalTags = implode(',', $arrayTags) .','.  $currentTags;                
                update_post_meta($post_id, 'alt_tags', $totalTags);
            }
        }

        /**
         * Associar preço do veiculo
         */

        if (!add_post_meta($post_id, 'alt_preco', $request['regular_price'], true)) {
            update_post_meta($post_id, 'alt_preco', $request['regular_price']);
        }

        if (!add_post_meta($post_id, 'alt_link_foto_360', $request['iframe_foto360'], true)) {
            update_post_meta($post_id, 'alt_link_foto_360', $request['iframe_foto360']);
        }
        
        /**
         * Validação se as imagens serão baixadas ou apenas salvo as urls
         * esse novo fluxo apenas se aplicará aos temas: altimus5
         */
        $temas_permitidos = array('altimus1', 'altimus2', 'altimus3','altimus4','altimus5');
        if (in_array(get_template(), $temas_permitidos) && !alt_is_portal()) {
            alt_novo_processamento_imagens($post_id, $request['images'], $copia_imagens);
        } else {          
            /**
             * Enviando as imagens para a tabela queue
             */
            alt_insert_queue_car_images($post_id, $request['images']);
            
            /**
             * Associar imagens ao veiculo
             */
            wp_schedule_single_event(alt_generate_timestamp_hook(), 'alt_salvar_imagem_no_veiculo');
        }    
        /**
         * Associar Carroceria
         */
        $carroceria = $request['carroceria'] ?? null;
        if (empty($carroceria) || strtolower($carroceria) == 'null' || $carroceria == null) {
            $carroceria = "Não definida";
        }
        $terms_carroceria = term_exists($carroceria, 'carroceria', 0);

        if (empty($terms_carroceria)) {
            $terms_carroceria = wp_insert_term($carroceria, 'carroceria', array('parent' => 0));
        }
        $parent_carroceria_id = $terms_carroceria['term_id'];
        wp_set_post_terms($post_id, $parent_carroceria_id, 'carroceria');
 

        /**
         * Associar veiculo a uma carroceria
         */
        $tipo = $request['tipo'] ?? 'Não definida';
        $termsTipo = term_exists($tipo, 'tipo', 0);
        if (empty($termsTipo)) {
            $termsTipo = wp_insert_term($tipo, 'tipo', array('parent' => 0));
        }
        $parent_tipo_id = $termsTipo['term_id'];
        wp_set_post_terms($post_id, $parent_tipo_id, 'tipo');
 

        /**
         * Associar veiculo a uma marca
         */
        $marca = $request['marca'] ?? 'Não definida';
        $termsMarca = term_exists($marca, 'marca', 0);

        if (empty($termsMarca)) {
            $termsMarca = wp_insert_term($marca, 'marca', array('parent' => 0));
        }
        $parent_marca_id = $termsMarca['term_id'];
        wp_set_post_terms($post_id, $parent_marca_id, 'marca');

        /**
         * Adicionar LOGO da Marca com base nas marcas padrões do sistema
         */
        if (empty(term_exists('marca_img', $parent_marca_id))) {
            $value_carro = alt_lista_marcas_padrao(strtolower($marca));

            $request_marca = $request['marca'];
            if ($request_marca == 'Honda') {
                if (strtolower($tipo) == 'moto') {
                    $value_moto = alt_lista_marcas_padrao(strtolower('honda-motos'));
                    if (!empty($value_moto)) {
                        $termsMarcaHondaMotos = term_exists('honda-motos', 'marca', 0);
                        if (empty($termsMarcaHondaMotos)) {
                            $termsMarcaHondaMotos = wp_insert_term('Honda', 'marca', array('parent' => 0, 'slug' => 'honda-motos'));
                        }
                        $parent_honda_marca_id = $termsMarcaHondaMotos['term_id'];
                        wp_set_post_terms($post_id, $parent_honda_marca_id, 'marca');
                    }
                }
            }

            if (!empty($value_carro)) {
                if (!add_term_meta($parent_marca_id, 'marca_img', $value_carro['imagem'], true)) {
                    update_term_meta($parent_marca_id, 'marca_img', $value_carro['imagem']);
                }
            }
            if (!empty($value_moto)) {
                if (!add_term_meta($parent_honda_marca_id, 'marca_img', $value_moto['imagem'], true)) {
                    update_term_meta($parent_honda_marca_id, 'marca_img', $value_moto['imagem']);
                }
            }
        };
 

        /**
         * Associar veiculo a um modelo
         */
        $modelo = $request['modelo'] ?? 'Não definida';
        $termsModelo = get_term_by('name', $modelo, 'modelo');

        $nomeModelo = $termsModelo->name ?? null;

        if (empty($nomeModelo)) {
            $nomeModelo = wp_insert_term($modelo, 'modelo', array('parent' => 0));
            $parent_modelo_id = $nomeModelo['term_id'];
        }else{
            $parent_modelo_id = $termsModelo -> term_id;
        }

        wp_set_post_terms($post_id, $parent_modelo_id, 'modelo');
        /**
         * Definir titulo pelo sistema
         */
        $nome = alt_formatar_titulo($post_id, $request);

        //A20-5715 - Após remoção do plugin pro, vamos sempre retornar a url de oferta (Landing Page) para o Altimus
        $url = str_replace('/veiculos/', '/oferta/', get_permalink($post_id));

        $response = [
            'nome' => $nome,
            'id' => $post_id,
            'url' => $url,
            'slug' => $url,
            'permalink' => $url,

        ];

        return $response;
    }
}

if(!function_exists('alt_get_iframe_360')){
    function alt_get_iframe_360($productId) {
        $iframeUrl = get_post_meta($productId, 'iframe_foto360', true);
        return $iframeUrl ?: null;
    }
    
    add_action('alt_get_iframe_360', 'alt_get_iframe_360', 1);
} 


if (!function_exists('alt_formatar_titulo')) {
    function alt_formatar_titulo($post_id, $request = [])
    {
        $arrFormacao = get_formacao_titulo();

        $metadata = [];

        if (isset($request['meta_data']) && is_array($request['meta_data'])) {
            foreach ($request['meta_data'] as $data) {
                $metadata[$data['key']] = $data['value'] ?? null;
            }
        }

        if (!empty($arrFormacao)) {
            $nome = "";
            
            if (in_array('marca', $arrFormacao)) {
                $objMarca = get_the_terms($post_id, 'marca');
                $nome .= $objMarca[0]->name . ' ';
            }
            if (in_array('modelo', $arrFormacao)) {
                $objModelo = get_the_terms($post_id, 'modelo');
                $nome .= $objModelo[0]->name . ' ';
            }
            if (in_array('modelo_complemento', $arrFormacao)) {

                $modelo_complemento = $metadata['alt_modelo_complemento'] ?? get_post_meta($post_id, 'alt_modelo_complemento', true);

                if (!empty($modelo_complemento)) {
                    $nome .= $modelo_complemento . ' ';
                }
            }
            
            /*Por padrão, salvamos o ano movedo no titulo do veículo*/
            $ano_modelo = $metadata['alt_ano_mod'] ?? get_post_meta($post_id, 'alt_ano_mod', true);

            //Adicionar uma barra entre o ano fab e ano mod
            if (isset($ano_fabricacao)) {
                $nome = substr($nome, 0, -1);
                $nome .= '/';
            }

            if (!empty($ano_modelo)) {
                $nome .= $ano_modelo . ' ';
            }
            
            if (in_array('cor', $arrFormacao)) {

                $cor = $metadata['alt_cor'] ?? get_post_meta($post_id, 'alt_cor', true);

                if (!empty($cor)) {
                    $nome .= $cor . ' ';
                }
            }
            if (in_array('porta', $arrFormacao)) {

                $portas = $metadata['alt_portas'] ?? get_post_meta($post_id, 'alt_portas', true);

                if (!empty($portas)) {
                    $nome .= $portas . 'P ';
                }
            }
            if (in_array('cambio', $arrFormacao)) {
                $cambio = $metadata['alt_cambio'] ?? get_post_meta($post_id, 'alt_cambio', true);

                if (!empty($cambio)) {
                    $nome .= $cambio . ' ';
                }
            }


            $my_post = array(
                'ID' => $post_id,
                'post_title' => $nome
            );

            wp_update_post($my_post);

            return $nome;
        }
        return $request['name'];
    }
}

if (!function_exists('alt_salvar_referencia_imagem_veiculo')) {
    function alt_salvar_referencia_imagem_veiculo($parent_post_id, $arrImagens)
    {

        if (!empty($arrImagens)) {
            //Ler todas as imagens
            $arrImg = [];
            foreach ($arrImagens as $indice => $image) {
                try {

                    $url_imagem = $image['src'];
                    $arrInfo = pathinfo($url_imagem);

                    $file = $url_imagem;
                    $filename = $arrInfo['basename'];
                    $type = 'image/jpeg';


                    $attachment = array(
                        'post_mime_type' => $type,
                        'post_title' => sanitize_file_name($filename),
                        'post_content' => '',
                        'post_status' => 'inherit',
                        'guid' => $url_imagem
                    );

                    $attach_id = wp_insert_attachment($attachment, false, $parent_post_id);

                    if ($indice == 0) {
                        update_post_meta($parent_post_id, 'alt_imagem_destaque', $file);
                        set_post_thumbnail($parent_post_id, $attach_id);
                    }

                    $arrImg[$attach_id] = $file;
                } catch (Exception $e) {
                    error_log($e->getMessage(), 3, 'erros-integracao-foto.log');
                    continue;
                }
            }

            //Serilizar os dados
            //Associar os dados com um campo
            if (!add_post_meta($parent_post_id, 'alt_imagens', $arrImg, true)) {
                update_post_meta($parent_post_id, 'alt_imagens', $arrImg);
            }
        }
    }
}



if (!function_exists('alt_salvar_imagem_no_veiculo')) {
    add_action('alt_salvar_imagem_no_veiculo', 'alt_salvar_imagem_no_veiculo', 10, 2);
    function alt_salvar_imagem_no_veiculo()
    {
        do {
            list($queue_id, $parent_post_id, $arrImagens, $meta_key) = alt_get_queue_car_images();
            $meta_key = $meta_key ?? 'alt_imagens';

            if (count($arrImagens) > 0) {
            
                //Ler todas as imagens
                $arrImg = [];
                foreach ($arrImagens as $indice => $image) {
                    try {

                        $url_original = $image['src'];
                        $upload_dir = wp_upload_dir();

                        $imagem_url = explode('/', $url_original);

                        $filename = basename(end($imagem_url));

                        if (wp_mkdir_p($upload_dir['path'])) {
                            $file = $upload_dir['path'] . '/' . $filename;
                        } else {
                            $file = $upload_dir['basedir'] . '/' . $filename;
                        }

                        if (!file_exists($file)) {
                            $i = 0;
                            $limit_try = 4;
                            while ($i < $limit_try) {

                                $image_data = file_get_contents($url_original);
                                if ($image_data) {
                                    $i = $limit_try;
                                }
                                $i++;
                            }
                            

                            //pegar parte final da URL
                            $url_desejada = end($imagem_url);

                            //Se existe o logo revenda, cocatena com o ID do veiculo
                            if ($url_desejada == 'logoRevenda.jpg') {
                                $imagem_url[7] = $parent_post_id . $url_desejada;
                            }

                            if (empty($image_data)) {
                                throw new Exception('Não foi possível baixar a imagem: ' . $url_original);
                            }

                            file_put_contents($file, $image_data);

                        }

                        $wp_filetype = wp_check_filetype($filename);

                        $attachment = array(
                            'post_mime_type' => $wp_filetype['type'],
                            'post_title' => sanitize_file_name($filename),
                            'post_content' => '',
                            'post_status' => 'inherit'
                        );

                        $attach_id = wp_insert_attachment($attachment, $file, $parent_post_id);

                        require_once(ABSPATH . 'wp-admin/includes/image.php');
                        $attach_data = wp_generate_attachment_metadata($attach_id, $file);
                        $res1 = wp_update_attachment_metadata($attach_id, $attach_data);
                        // update_post_meta($attach_id, '_wp_attachment_image_alt', 'Foto do veículo ' . $indice);
                        if ($indice == 0) {
                            try {
                                set_post_thumbnail($parent_post_id, $attach_id);
                            } catch (Exception $e) {
                                error_log($e->getMessage(), 0, 'erros-thumbnail.log');
                            }
                        }
                        $arrImg[$attach_id] = $upload_dir['baseurl'] . '/' . $attach_data['file'];
                        

                    } catch (Exception $e) {
                        error_log($e->getMessage(), 0, 'erros-integracao-foto.log');
                        continue;
                    }
                }

                if (count($arrImg) > 0) {
                    //Serilizar os dados
                    //Associar os dados com um campo
                    if (!add_post_meta($parent_post_id, $meta_key, $arrImg, true)) {
                        update_post_meta($parent_post_id, $meta_key, $arrImg);
                    }
                }

            }
            //removemos o else, pois independente de existir imagem, o registro deve ser removido
            alt_delete_queue_car_images($queue_id);

            //movido para fora do if de download de imagem para sempre limpar cache na Gocache
            alt_limpeza_cache($parent_post_id);

        } while(alt_count_queue_car_images() > 0);
    }
}
/**
 * Totalizador de clicks em veículos
 * @return string
 */

function alt_limpeza_cache($post_id)
 {
    /**
     * 
    */
    //Pegar link do post
    $protocols = array('http://', 'http://www.', 'https://', 'https://www.' , 'www.');   
    $url_site = str_replace($protocols, '', get_bloginfo('wpurl'));
    $post_url = get_permalink($post_id);
    $token_go_cache = '9e56abf4735de1603f885fcee1c47913';
    $urls = array(
        "urls[1]=" . 'https://' . $url_site . '/',
        "urls[2]=" . $post_url,
        "urls[3]=" . str_replace('/veiculos/', '/oferta/', $post_url)
        );
    
    $curl = curl_init();

    curl_setopt_array($curl, array(
    CURLOPT_URL => 'https://api.gocache.com.br/v1/cache/' . $url_site,
    CURLOPT_RETURNTRANSFER => true,
    CURLOPT_ENCODING => '',
    CURLOPT_MAXREDIRS => 10,
    CURLOPT_TIMEOUT => 0,
    CURLOPT_FOLLOWLOCATION => true,
    CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
    CURLOPT_CUSTOMREQUEST => 'DELETE',
    CURLOPT_POSTFIELDS => implode("&", $urls),
    CURLOPT_HTTPHEADER => array(
        'GoCache-Token: ' . $token_go_cache,
        'Content-Type: application/x-www-form-urlencoded',
        'Cookie: __goc_session__=tgcwspbdhrdlesbrxqqrrxsuoiqrswra'
    ),
    ));
    
    $response = curl_exec($curl);
    if ($response === false) {
        $curl_error = curl_error($curl);
        error_log('Erro na requisição API da GoCache: ' . $curl_error);
    }

    curl_close($curl);
}


function alt_get_post_view()
{
    $count = get_post_meta(get_the_ID(), 'post_views_count', true);
    return $count;
}

//Total de visualizações do veiculo
function alt_set_post_view($post_id = null)
{

    $key = 'post_views_count';
    $post_id = get_the_ID();
    $count = (int)get_post_meta($post_id, $key, true);
    $count++;
    update_post_meta($post_id, $key, $count);
}


function alt_posts_column_views($columns)
{
    $columns['post_views'] = 'Visualizações';
    return $columns;
}

function alt_posts_custom_column_views($column)
{
    if ($column === 'post_views') {
        echo alt_get_post_view();
    }
}

function alt_generate_timestamp_hook()
{
    $time = null;
    $sum = 60;

    foreach (_get_cron_array() as $key => $value) {
        if (!empty($value['alt_salvar_imagem_no_veiculo'])) {
            $time = $key + $sum;
        }
    }

    if (!$time) {
        $time = time() + 1;
    }
    
    return $time;
}

add_filter('manage_veiculos_posts_columns', 'alt_posts_column_views');
add_action('manage_veiculos_posts_custom_column', 'alt_posts_custom_column_views');

function autocomplete_action() {
    // Aqui você faz a consulta no banco de dados ou qualquer lógica necessária
    $term = sanitize_text_field($_GET['term']);
    
    // Consulta personalizada nas tabelas wp_terms e wp_term_taxonomy
    global $wpdb;

    // SQL para buscar os termos na tabela wp_terms com a taxonomia 'marca' ou 'modelo', sem resultados duplicados
    $sql = "
        SELECT DISTINCT t.name
        FROM {$wpdb->terms} t
        INNER JOIN {$wpdb->term_taxonomy} tt ON t.term_id = tt.term_id
        WHERE tt.taxonomy IN ('marca', 'modelo')
        AND t.name LIKE %s
    ";

    // Preparando e executando a consulta
    $query = $wpdb->prepare($sql, '%' . $wpdb->esc_like($term) . '%');
    $results_db = $wpdb->get_results($query);

    // Resultados a serem retornados para o autocomplete
    $results = array();
    
    if ($results_db) {
        foreach ($results_db as $result) {
            $results[] = array(
                'label' => $result->name,  // O nome da marca ou modelo
                'value' => $result->name,  // Valor que será enviado quando selecionado
            );
        }
    }

    // Retorna os resultados como JSON
    echo json_encode($results);
    wp_die(); // Finaliza a requisição Ajax
}

add_action('wp_ajax_autocomplete_action', 'autocomplete_action');
add_action('wp_ajax_nopriv_autocomplete_action', 'autocomplete_action');

/**
 * Responsável pelo novo fluxo de processamento de imagens.
 * As imagens não serão mais baixadas, mas sim utilizadas as URLs que estão na CDN.
 *
 * @param int $post_id O ID do post do veículo.
 * @param array $lista A lista de imagens a serem processadas.
 * @param array $copia_imagens Lista de imagens a serem deletadas.
 *
 * Esta função realiza as seguintes operações:
 * 1. Verifica se existe pelo menos uma imagem na lista.
 * 2. Percorre a lista de imagens e adiciona cada imagem na lista de imagens a serem salvas.
 * 3. Se a imagem for a principal (primeira), cria o thumbnail alternativo.
 * 4. Salva a listagem de imagens em 'alt_imagens_url'.
 * 5. Deleta as imagens associadas ao post através da função `alt_delete_imagens_veiculos`.
 *
 * @return void
 */
function alt_novo_processamento_imagens($post_id, $lista, $copia_imagens = [])
{
    //Verificar se existe pelo menos uma imagem na lista
    if (count($lista) > 0) {
        $arrImg = [];

        //Verificar se a imagem é a principal, no caso a primeira, se for, cria o thumbnail alternativo
        $thumbnail = $lista[0]['src'];
        if(!empty($thumbnail)){
            update_post_meta($post_id, '_veiculo_thumbnail_url', $thumbnail);
            update_post_meta($post_id, 'alt_imagem_destaque', $thumbnail);
        }
      
        //Percorrer a lista de imagens
        foreach ($lista as $item) {
            //Adicionar a imagem na lista
            $arrImg[] = [
                'src' => $item["src"],
                'alt' => $item["alt"],
                'position' => $item["position"]
            ];
            $item["src"];
        }
        if (count($lista) > 0) {
            //Salvar imagem principal
            if (!add_post_meta($post_id, 'alt_imagens_url', $arrImg, true)) {
                update_post_meta($post_id, 'alt_imagens_url', $arrImg);
            }
        }
        if (is_countable($copia_imagens) && count($copia_imagens) > 0) {
            alt_delete_imagens_veiculos($post_id, $copia_imagens);
        }
    }
}

/**
 * Função para deletar imagens associadas a um post de veículos.
 *
 * @param int $post_id O ID do post do veículo.
 * @param array $copia_imagens Lista de imagens a serem deletadas.
 * @return array Mensagem indicando o status da operação.
 *
 * Esta função realiza as seguintes operações:
 * 1. Obtém o post correspondente ao ID fornecido.
 * 2. Verifica se o post existe. Se não existir, retorna uma mensagem de erro.
 * 3. Verifica se a lista de imagens não está vazia e é um array.
 * 4. Para cada imagem na lista, deleta o anexo correspondente e o arquivo físico, se existir.
 * 5. Executa a função de limpeza de cache após excluir as imagens.
 */
if (!function_exists('alt_delete_imagens_veiculos')) {
    function alt_delete_imagens_veiculos($post_id, $copia_imagens)
    {
        try {
            $post = get_post($post_id);
            
            if (empty($post)) {
                return ['msg' => 'Veiculo não encontrado'];
            }
            
            if (!empty($copia_imagens) && is_array($copia_imagens)) {
                // Correto: Iterando através do primeiro elemento do array que contém os anexos
                foreach ($copia_imagens as $id => $attachment) {
                    // Verifique se o ID é numérico
                    if (is_numeric($id)) {
                        $id = (int)$id; // Garante que o ID seja um inteiro
                        
                        // Verificar se o anexo existe
                        if (get_post($id) && get_post_type($id) === 'attachment') {
                            // Force a exclusão do arquivo físico também
                            $file = get_attached_file($id);
                            $deleted = wp_delete_attachment($id, true);
                            
                            // Se wp_delete_attachment falhar, tente wp_delete_post
                            if (!$deleted) {
                                wp_delete_post($id, true);
                            }
                            
                            // Se o arquivo ainda existir, tente removê-lo diretamente
                            if (file_exists($file)) {
                                @unlink($file);
                            }
                        }
                    }
                }
            }

            alt_limpeza_cache($post_id);
            return ['msg' => 'Imagens deletadas com sucesso'];
            
        } catch (Exception $e) {
            error_log('Erro ao deletar imagens no novo fluxo: ' . $e->getMessage());
            return ['msg' => 'Erro ao deletar imagens: ' . $e->getMessage()];
        }
    }
}