<?php
require_once plugin_dir_path(__FILE__) . 'metabox/metabox_time.php';

function alt_time()
{
    $args_cursos_post_type = array(
        'labels' => array('name' => 'Time/Vendedores', 'add_new' => 'Adicionar', 'add_new_item' => 'Adicionar', 'edit_item' => 'Editar'),
        'public' => true,
        'menu_icon' => 'dashicons-format-image',
        'supports' => array('title', 'editor'),
        'register_meta_box_cb' => '');
    register_post_type('time', $args_cursos_post_type);
}

add_action('init', 'alt_time');


function wpb_change_title_text($title)
{
    $screen = get_current_screen();

    if ('time' == $screen->post_type) {
        $title = 'Nome do vendedor';
    }
    return $title;
}

add_filter('enter_title_here', 'wpb_change_title_text');


if (!function_exists('alt_exibir_time')) {
    add_action('alt_exibir_time', 'alt_exibir_time');
    function alt_exibir_time()
    {

        $args = array('numberposts' => 10, 'post_type' => 'time', 'post_status' => array('publish'));
        $posts = get_posts($args);
        $arrPosts = [];
        foreach ($posts as $post) {


            $whatsapp = get_post_meta($post->ID, 'alt_whatsapp', true);
            $arrData['whatsapp'] = gerarLink($whatsapp , 'whatsapp') ?? null;
            $arrData['whatsapp_exibicao'] = formatarNumero($whatsapp);

            $arrData['telefone'] = gerarLink(get_post_meta($post->ID, 'alt_telefone', true), 'telefone') ?? null;
            $arrData['experiencia'] = get_post_meta($post->ID, 'alt_experiencia', true) ?? null;


            $arrData['email'] = gerarLink(get_post_meta($post->ID, 'alt_email', true), 'email') ?? null;
            $arrData['email_exibir'] = get_post_meta($post->ID, 'alt_email', true) ?? null;


            $arrData['url_img'] = get_post_meta($post->ID, 'alt_time_imagem', true) ?? null;
            $arrData['cargo'] = get_post_meta($post->ID, 'alt_cargo', true) ?? null;
            $arrData['nome'] = $post->post_title;
            $arrData['descricao'] = $post->post_content;
            $arrPosts[] = $arrData;
        }

        return $arrPosts;

    }


}

