<?php
require_once plugin_dir_path(__FILE__) . 'metabox/metabox_popups.php';

function alt_post_popups()
{

    $args_cursos_post_type = array(
        'labels' => array('name' => 'Gerenciar Popups',
            'add_new' => 'Adicionar popup',
            'add_new_item' => 'Adicionar popups',
            'edit_item' => 'Editar popups'
        ),
        'public' => true,
        'show_ui' => true,
        'query_var' => true,
        'menu_icon' => 'dashicons-welcome-widgets-menus',
        'supports' => array(
            'title',
            'editor'
        ),
        'register_meta_box_cb' => ''
    );
    register_post_type('popups', $args_cursos_post_type);
}

add_action('init', 'alt_post_popups');


if (!function_exists('mostrar_popups')) {
    function mostrar_popups()
    {


        $args = array(
            'posts_per_page' => 1,
            'post_type' => 'popups',
            'post_status' => array('publish'),
            'orderBy' => 'date',
            'order' => 'desc'
        );

        $query = new WP_Query($args);
        $post_count = $query->post_count;
        $arrPopups = $query->posts;

        if (empty($arrPopups)) {
            return;
        }
        ?>

        <style>
            .popup_div {
                position: fixed;
                top: 0;
                right: 0;
                bottom: 0;
                left: 0;
                z-index: 1050;
                xdisplay: none;
                overflow: hidden;
                -webkit-overflow-scrolling: touch;
                outline: 0;
            }

            .popup_div_dialog {
                width: 650px;
                margin: 30px auto;
                position: relative;
            }


            .popup_div_content {
                width: 650px;
                margin: auto;
                position: relative;
                top: 20%;

                border: 1px solid #fff;
                background: #fff;
                box-shadow: 2px 2px 5px #000000;


            }

            .popup_div_close {
                position: absolute;
                right: 0;
                cursor: pointer;
            }

            .saida_popup {
                display: none;
            }

            @media only screen and (max-width: 600px) {
                .popup_div_content {
                    width: 60%;
                }
            }

        </style>

        <?php foreach ($arrPopups as $popup): ?>


        <?php

        $sn = get_post_meta($popup->ID, 'tempo_exibicao', true);

        ?>

        <div class="popup_div <?= $sn == 'entrada' ? 'entrada_popup' : 'saida_popup' ?>" id="myPopupAlt">
            <div class="popup_div_content">
                <div class="popup_div_close" onclick="close_modal_popup_alt()">
                    <i class="far fa-times-circle fa-2x"></i>
                </div>
                <div class="popup_div_body">
                    <?= $popup->post_content; ?>
                </div>
            </div>
        </div>

    <?php endforeach; ?>

        <script>

            <?php if($sn == 'saida'):?>

            function addEvent(obj, evt, fn) {
                if (obj.addEventListener) {
                    obj.addEventListener(evt, fn, false);
                } else if (obj.attachEvent) {
                    obj.attachEvent("on" + evt, fn);
                }
            }

            addEvent(window, "load", function (e) {
                addEvent(document, "mouseout", function (e) {
                    e = e ? e : window.event;
                    var from = e.relatedTarget || e.toElement;
                    if (!from || from.nodeName == "HTML") {
                        var element = document.getElementsByClassName("saida_popup");

                        if (sessionStorage.getItem("exibirModal")) {
                            var x = document.getElementById("myPopupAlt");
                            x.style.display = "none";
                        } else {
                            element[0].style.display = 'block';
                        }


                    }
                });
            });

            <?php endif;?>

            function close_modal_popup_alt() {
                var x = document.getElementById("myPopupAlt");
                if (x.style.display === "none") {
                    x.style.display = "block";
                } else {
                    x.style.display = "none";
                    sessionStorage.setItem("exibirModal", true);
                }

            }

            function checkModalAlt() {
                if (sessionStorage.getItem("exibirModal")) {
                    var x = document.getElementById("myPopupAlt");
                    x.style.display = "none";
                }
            }

            checkModalAlt();
        </script>

        <?php


    }

    add_action('after_body_open_tag', 'mostrar_popups', 10, 1);
}
