<?php
if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly
}

function formatarNumero($TEL)
{
    $tam = strlen(preg_replace("/[^0-9]/", "", $TEL));
    if ($tam == 13) { // COM CÓDIGO DE ÁREA NACIONAL E DO PAIS e 9 dígitos
        return "+" . substr($TEL, 0, $tam - 11) . "(" . substr($TEL, $tam - 11, 2) . ")" . substr($TEL, $tam - 9, 5) . "-" . substr($TEL, -4);
    }
    if ($tam == 12) { // COM CÓDIGO DE ÁREA NACIONAL E DO PAIS
        return "+" . substr($TEL, 0, $tam - 10) . "(" . substr($TEL, $tam - 10, 2) . ")" . substr($TEL, $tam - 8, 4) . "-" . substr($TEL, -4);
    }
    if ($tam == 11) { // COM CÓDIGO DE ÁREA NACIONAL e 9 dígitos
        return "(" . substr($TEL, 0, 2) . ")" . substr($TEL, 2, 5) . "-" . substr($TEL, 7, 11);
    }
    if ($tam == 10) { // COM CÓDIGO DE ÁREA NACIONAL
        return "(" . substr($TEL, 0, 2) . ")" . substr($TEL, 2, 4) . "-" . substr($TEL, 6, 10);
    }
    if ($tam <= 9) { // SEM CÓDIGO DE ÁREA
        return substr($TEL, 0, $tam - 4) . "-" . substr($TEL, -4);
    }
}

function gerarLink($valor, $tipo)
{

    if (empty($valor)) {
        return null;
    }

    $url = '#';
    if ($tipo == 'telefone') {
        $url = 'tel:' . $valor;
    }

    if ($tipo == 'email') {
        $url = 'mailto:' . $valor;
    }

    if ($tipo == 'whatsapp') {
        $iphone = strpos($_SERVER['HTTP_USER_AGENT'], "iPhone");
        $android = strpos($_SERVER['HTTP_USER_AGENT'], "Android");
        $palmpre = strpos($_SERVER['HTTP_USER_AGENT'], "webOS");
        $berry = strpos($_SERVER['HTTP_USER_AGENT'], "BlackBerry");
        $ipod = strpos($_SERVER['HTTP_USER_AGENT'], "iPod");
        $url = 'https://api.whatsapp.com/send?phone=55' . $valor;
    }


    return $url;
}

function formatarDados($arrEntrada)
{


    $tipo = $arrEntrada['tipo'];
    $valor = $arrEntrada['valor'];
    $descricao = $arrEntrada['descricao'] ?? null;

    $arrTelefone = $arrEntrada;
    $arrTelefone['numero'] = formatarNumero($valor);
    $arrTelefone['link'] = gerarLink($valor, $tipo);
    $arrTelefone['descricao'] = !empty($descricao) ? ' - ' . $descricao : null;


    return $arrTelefone;
}