<?php

add_action('cmb2_init', 'alt_metabox_endereco');
add_action('cmb2_init', 'alt_metabox_filial_contato');
add_action('cmb2_init', 'alt_metabox_filial_detalhes');
add_action('cmb2_init', 'alt_metabox_filial_redes_sociais');

/**
 * Define the metabox and field configurations.
 */
function alt_metabox_endereco()
{
    $estados = array(
        'AC' => 'Acre',
        'AL' => 'Alagoas',
        'AP' => 'Amapá',
        'AM' => 'Amazonas',
        'BA' => 'Bahia',
        'CE' => 'Ceará',
        'DF' => 'Distrito Federal',
        'ES' => 'Espirito Santo',
        'GO' => 'Goiás',
        'MA' => 'Maranhão',
        'MS' => 'Mato Grosso do Sul',
        'MT' => 'Mato Grosso',
        'MG' => 'Minas Gerais',
        'PA' => 'Pará',
        'PB' => 'Paraíba',
        'PR' => 'Paraná',
        'PE' => 'Pernambuco',
        'PI' => 'Piauí',
        'RJ' => 'Rio de Janeiro',
        'RN' => 'Rio Grande do Norte',
        'RS' => 'Rio Grande do Sul',
        'RO' => 'Rondônia',
        'RR' => 'Roraima',
        'SC' => 'Santa Catarina',
        'SP' => 'São Paulo',
        'SE' => 'Sergipe',
        'TO' => 'Tocantins',
    );
    // Start with an underscore to hide fields from custom fields list
    $prefix = 'alt_';

    /**
     * Initiate the metabox
     */
    $cmb = new_cmb2_box(array(
        'id' => 'field_filial_dados',
        'title' => 'Informações',
        'object_types' => array('filiais',), // Post type
        'context' => 'normal',
        'priority' => 'high',
        'show_names' => true,
        'show_in_rest' => false,

    ));


    $cmb->add_field(array(
        'name' => 'CNPJ',
        'desc' => 'Inserir apenas números. Ex: 00000000000000',
        'id' => $prefix . 'cnpj_principal',
        'default' => '',
        'type' => 'text',

    ));
    $cmb->add_field(array(
        'name' => 'Endereço',
        'desc' => 'Ex: R.João Pessoa 2008 - Sala 01',
        'default' => '',
        'id' => $prefix . 'endereco_principal',
        'type' => 'text',
    ));
    $cmb->add_field(array(
        'name' => 'Cidade',
        'desc' => 'Ex: Blumenau',
        'default' => '',
        'id' => $prefix . 'cidade_principal',
        'type' => 'text',
    ));
    $cmb->add_field(array(
        'name' => 'Estado',
        'desc' => '',
        'default' => '',
        'id' => $prefix . 'estado_principal',
        'type' => 'select',
        'default' => 'SC',
        'options' => $estados,
    ));

    $cmb->add_field(array(
        'name' => 'CEP',
        'desc' => 'Somente números Ex: 89040400',
        'default' => '',
        'id' => $prefix . 'cep',
        'type' => 'text',
    ));

    $cmb->add_field(array(
        'name' => 'URL Google Maps',
        'desc' => 'Acessar o Google maps para obter a URL. Ex: https://goo.gl/maps/BS6nTdNqkBQeoQbJ7',
        'default' => '',
        'id' => $prefix . 'google_maps',
        'type' => 'text',
    ));

    $cmb->add_field(array(
        'name' => 'Telefone fixo',
        'desc' => 'Utilizar apenas números. exemplo 4788888888',
        'id' => $prefix . 'telefone_principal',
        'default' => '',
        'type' => 'text',
    ));

    $cmb->add_field(array(
        'name' => 'Whatsapp Principal',
        'desc' => 'Utilizar apenas números. exemplo 4788888888',
        'id' => $prefix . 'whatsapp_principal',
        'default' => '',
        'type' => 'text',
    ));

    $cmb->add_field(array(
        'name' => 'E-mail principal',
        'desc' => '',
        'id' => $prefix . 'email_principal',
        'default' => '',
        'type' => 'text',
    ));


    $cmb->add_field(
        array(
            'name' => 'Matriz',
            'desc' => 'É uma matriz?',
            'id' => $prefix . 'matriz',
            'type' => 'checkbox',
            'default' => false,
            'show_on_cb' => true,

        )
    );

    $cmb->add_field(
        array(
            'name' => 'Script GoogleMaps',
            'desc' => '<a target="_blank" href="https://www.google.com.br/maps">Obter link</a>',
            'id' => $prefix . 'filial_mapa',
            'type' => 'wysiwyg',
        )
    );


    $cmb->add_field(
        array(
            'name' => 'Horário de funcionamento',
            'desc' => '',
            'id' => $prefix . 'horario_funcionamento',
            'type' => 'textarea',
        )
    );


    $cmb->add_field(
        array(
            'name' => 'Chave Altimus',
            'desc' => 'Chave fornecida pelo sistema Altimus para integração de veículos',
            'id' => $prefix . 'filiais_chave_altimus',
            'type' => 'text',
            'show_on_cb' => 'cmb2_hide_if_no_cats'
        )
    );
}


function alt_metabox_filial_contato()
{
    $prefix = 'alt_';

    /**
     * Initiate the metabox
     */
    $cmb = new_cmb2_box(array(
        'id' => 'field_filial_contato',
        'title' => 'Contatos da loja',
        'object_types' => array('filiais'), // Post type
        'context' => 'normal',
        'priority' => 'high',
        'show_names' => true,
        'show_in_rest' => false,
    ));


    $group_field_id = $cmb->add_field(array(
        'id' => $prefix . 'filial_contatos',
        'type' => 'group',
        'title' => 'Contatos',
        'description' => '',
        //'repeatable'  => false, // use false if you want non-repeatable group
        'options' => array(
            'group_title' => 'Contatos {#}', // since version 1.1.4, {#} gets replaced by row number
            'add_button' => 'Adicionar contatos',
            'remove_button' => 'Remover contatos',
            'sortable' => true,
            'closed' => true, // true to have the groups closed by default
            'remove_confirm' => 'Tem certeza que deseja remover esse contato?', // Performs confirmation before removing group.
        ),
    ));

    // Id's for group's fields only need to be unique for the group. Prefix is not needed.
    $cmb->add_group_field($group_field_id, array(
        'name' => 'Tipo de contato',
        'desc' => 'De acordo com o tipo, alguma formatação pode ser aplicada no campo <b>Valor</b>.',
        'id' => 'icone',
        'type' => 'select',
        'default' => 'telefone',
        'options' => array(
            'fab fa-whatsapp' => 'Whatsapp',
            'fa fa-phone' => 'Telefone',
            'fa fa-envelope' => 'E-mail',
            'fa fa-map-marked' => 'Mapa',
            'fa fa-car' => 'Carro',
        ),
    ));
    
    $cmb->add_group_field($group_field_id, array(
        'name' => 'Valor',
        'desc' => 'Se for telefone ou whatsapp, informe apenas números. Nos demais, o conteúdo corresponde.',
        'id' => 'url_valor',
        'type' => 'text',
        'default' => '#',
        'attributes' => array(
            'data-tipo' => true,
            'class' => 'alt-input-mask'
        )
    ));



    $cmb->add_group_field($group_field_id, array(
        'name' => 'Titulo',
        'id' => 'titulo',
        'type' => 'text',
        // 'repeatable' => true, // Repeatable fields are supported w/in repeatable groups (for most types)
    ));

    $cmb->add_group_field($group_field_id, array(
        'name' => 'Subtitulo',
        'id' => 'subtitulo',
        'type' => 'text',
        // 'repeatable' => true, // Repeatable fields are supported w/in repeatable groups (for most types)
    ));
}

function alt_metabox_filial_detalhes()
{
    $prefix = 'alt_';

    /**
     * Initiate the metabox 
     */
    $cmb = new_cmb2_box(array(
        'id' => 'field_filial_detalhes',
        'title' => 'Detalhes da loja (Apenas tema 5)',
        'object_types' => array('filiais'), // Post type
        'context' => 'normal',
        'priority' => 'high',
        'show_names' => true,
        'show_in_rest' => false,
    ));

    $cmb->add_field(
        array(
            'name' => 'Texto sobre',
            'desc' => 'O texto será exibido na pagina da Empresa',
            'id' => $prefix . 'filial_texto_empresa',
            'type' => 'wysiwyg',
        )
    );

    $cmb->add_field(
        array(
            'name' => 'Titulo Página Empresa',
            'desc' => 'O titulo será exibido na pagina da Empresa',
            'id' => $prefix . 'filial_titulo_empresa',
            'type' => 'wysiwyg',
        )
    );

    $cmb->add_field(
        array(
            'name' => __('URL Youtube', 'cmb2'),
            'desc' => __('Informe url do vídeo no youtube', 'cmb2'),
            'id' => $prefix . 'filial_youtube_empresa',
            'type' => 'text_url',
        )
    );

    $cmb->add_field(
        array(
            'name' => 'Texto - Venda',
            'desc' => 'O texto será exibido no widget de Venda',
            'id' => $prefix . 'filial_texto_venda',
            'type' => 'wysiwyg',
        )
    );

    $cmb->add_field(
        array(
            'name' => 'Imagem - Venda',
            'desc' => 'Selecione uma imagem (Com fundo transparente)',
            'id' => $prefix . 'filial_imagem_venda',
            'type' => 'file',
            'options' => array(
                'url' => false, // Hide the text input for the url
            ),
            'text' => array(
                'add_upload_file_text' => 'Selecione' // Change upload button text. Default: "Add or Upload File"
            )

        )
    );

    $cmb->add_field(
        array(
            'name' => 'Texto - Simulação',
            'desc' => 'O texto será exibido no widget de Simulação',
            'id' => $prefix . 'filial_texto_simulacao',
            'type' => 'wysiwyg',
        )
    );

    $cmb->add_field(
        array(
            'name' => 'Imagem - Simulação',
            'desc' => 'Selecione uma imagem (Com fundo transparente)',
            'id' => $prefix . 'filial_imagem_simulacao',
            'type' => 'file',
            'options' => array(
                'url' => false, // Hide the text input for the url
            ),
            'text' => array(
                'add_upload_file_text' => 'Selecione' // Change upload button text. Default: "Add or Upload File"
            )

        )
    );
}

function alt_metabox_filial_redes_sociais()
{
    $prefix = 'alt_';

    /**
     * Initiate the metabox 
     */
    $cmb = new_cmb2_box(array(
        'id' => 'field_filial_redes_sociais',
        'title' => 'Redes Sociais da loja (Apenas tema 5)',
        'object_types' => array('filiais'), // Post type
        'context' => 'normal',
        'priority' => 'high',
        'show_names' => true,
        'show_in_rest' => false,
    ));

    $cmb->add_field(array(
        'name' => 'Facebook',
        'desc' => 'Inserir a Url',
        'id' => $prefix . 'filial_facebook',
        'type' => 'text_url',
    ));

    $cmb->add_field(array(
        'name' => 'Instagram',
        'desc' => 'Inserir a Url',
        'id' => $prefix . 'filial_instagram',
        'type' => 'text_url',
    ));

    $cmb->add_field(array(
        'name' => 'TikTok',
        'desc' => '',
        'id' => 'tiktok',
        'type' => 'text_url',
    ));
    $cmb->add_field(array(
        'name' => 'Twitter',
        'desc' => '',
        'id' => 'twitter',
        'type' => 'text_url',
    ));
    $cmb->add_field(array(
        'name' => 'Youtube',
        'desc' => '',
        'id' => 'youtube',
        'type' => 'text_url',
    ));
    $cmb->add_field(array(
        'name' => 'Linkedin',
        'desc' => '',
        'id' => 'linkedin',
        'type' => 'text_url',
    ));

    $cmb->add_field(array(
        'name' => 'Botão flutuante Whatsapp',
        'desc' => 'Exibir o botão flutuante?',
        'id' => $prefix . 'button_whatsapp',
        'type' => 'select',
        'default' => 'sim',
        'options' => ['sim' => 'Sim', 'nao' => 'Não'],
    ));
}

function alt_get_filiais_matriz()
{

    $matriz = array(
        'relation' => 'AND',
        array(
            'key' => 'alt_matriz',
            'compare' => '=',
            'value' => 'on',
        )
    );


    $args = array(
        'post_type' => 'filiais',
        'post_status' => array('publish'),
        'orderBy' => 'date',
        'order' => 'asc',
        'meta_query' => $matriz
    );


    $query = new WP_Query($args);

    $arrFiliais = $query->posts;

    $arrRetorno = [];

    foreach ($arrFiliais as $filial) {

        $data = alt_formatar_filial($filial);
        $arrRetorno[] = $data;
    }

    wp_reset_query();

    return $arrRetorno;
}

function alt_formatar_filial($filial)
{


    $id_filial = $filial->ID;

    $data['id'] = $id_filial;
    $data['nome'] = $filial->post_title;
    $data['cnpj'] = get_post_meta($id_filial, 'alt_cnpj_principal', true);
    $data['telefone'] = get_post_meta($id_filial, 'alt_telefone_principal', true);
    $data['email'] = get_post_meta($id_filial, 'alt_email_principal', true);
    $data['whatsapp'] = get_post_meta($id_filial, 'alt_whatsapp_principal', true);
    $data['horarios'] = get_post_meta($id_filial, 'alt_horario_funcionamento', true);
    $data['matriz'] = get_post_meta($id_filial, 'alt_matriz', true);
    $data['endereco'] = get_post_meta($id_filial, 'alt_endereco_principal', true);
    $data['cidade'] = get_post_meta($id_filial, 'alt_cidade_principal', true);
    $data['estado'] = get_post_meta($id_filial, 'alt_estado_principal', true);
    $data['cep'] = get_post_meta($id_filial, 'alt_cep', true);

    $data['texto_empresa'] = get_post_meta($id_filial, 'alt_filial_texto_empresa', true);
    $data['titulo_empresa'] = get_post_meta($id_filial, 'alt_filial_titulo_empresa', true);
    $data['youtube_empresa'] = get_post_meta($id_filial, 'alt_filial_youtube_empresa', true);
    $data['texto_venda'] = get_post_meta($id_filial, 'alt_filial_texto_venda', true);
    $data['imagem_venda'] = get_post_meta($id_filial, 'alt_filial_imagem_venda', true);
    $data['texto_simulacao'] = get_post_meta($id_filial, 'alt_filial_texto_simulacao', true);
    $data['imagem_simulacao'] = get_post_meta($id_filial, 'alt_filial_imagem_simulacao', true);

    $data['facebook'] = get_post_meta($id_filial, 'alt_filial_facebook', true);
    $data['instagram'] = get_post_meta($id_filial, 'alt_filial_instagram', true);
    $data['youtube'] = get_post_meta($id_filial, 'alt_filial_youtube', true);
    $data['btn_whats'] = get_post_meta($id_filial, 'alt_button_whatsapp', true);

    $data['nome_principal'] = $data['nome'];
    $data['cnpj_principal'] = $data['cnpj'];
    $data['telefone_principal'] = $data['telefone'];
    $data['email_principal'] = $data['email'];
    $data['numero_whatsapp'] = $data['whatsapp'];


    $data['endereco_principal'] = $data['endereco'];
    $data['cidade_principal'] = $data['cidade'];
    $data['estado_principal'] = $data['estado'];


    if (!empty($data['telefone'])) {
        $data['url_telefone'] = 'tel:' . $data['telefone'];

        $data['telefone'] = alt_mascara_fone($data['telefone']);
    }

    if (!empty($data['email'])) {
        $data['url_email'] = 'mailto:' . $data['email'];
    }

    if (!empty($data['whatsapp'])) {
        $data['url_whatsapp'] = 'https://wa.me/55' . $data['whatsapp'];
        $data['whatsapp'] = alt_mascara_fone($data['whatsapp']);
    }


    $data['endereco_completo'] = $data['endereco'] . ' - ' . $data['cidade'] . ' - ' . $data['estado'];

    $data['url_mapa'] = get_post_meta($id_filial, 'alt_google_maps', true);


    $data['script_mapa'] = get_post_meta($id_filial, 'alt_filial_mapa', true);


    $data['outros_contatos'] =  get_post_meta($id_filial, 'alt_filial_contatos', true);



    return $data;
}

function alt_get_filiais()
{

    $args = array(
        'post_type' => 'filiais',
        'post_status' => array('publish'),
        'orderBy' => 'date',
        'order' => 'asc'
    );

    $query = new WP_Query($args);

    $arrFiliais = $query->posts;


    $arrRetorno = [];

    foreach ($arrFiliais as $filial) {


        $data = alt_formatar_filial($filial);
        $arrRetorno[] = $data;
    }


    return $arrRetorno;
}

function alt_formatar_contatos($contatos)
{
    if (!is_array($contatos)) {
        return [];
    }

    $output = [
        'fone' => [],
        'whats' => []
    ];

    $mensagem = '?text=Estou no site ' . alt_get_title_site() . ' e gostaria de mais informações! ' . home_url();

    foreach ($contatos as $contato) {
        if ( !empty($contato['url_valor']) && $contato['url_valor'] != '#') {
            switch ($contato['icone']) {
                case 'fab fa-whatsapp':
                    $whatsapp = [
                        'url_whatsapp' => 'https://wa.me/+55' . $contato['url_valor'] . $mensagem,
                        'whatsapp' => (strlen($contato['url_valor']) == 11)
                            ? alt_mascara('(##) #####-####', $contato['url_valor'])
                            : alt_mascara('(##) ####-#####', $contato['url_valor'])
                    ];
                    $output['whats'][] = $whatsapp;
                    break;

                case 'fa fa-phone':
                    $telefone = [
                        'url_telefone' => 'tel:' . $contato['url_valor'],
                        'telefone' => (strlen($contato['url_valor']) == 11)
                            ? alt_mascara('(##) #####-####', $contato['url_valor'])
                            : alt_mascara('(##) ####-#####', $contato['url_valor'])
                    ];
                    $output['fone'][] = $telefone;
                    break;

                default:
                    // Caso algum ícone não seja WhatsApp ou telefone, você pode adicionar tratamento aqui
                    break;
            }
        }
    }

    return $output;
}

add_action('admin_footer', function() {
?>
    <script>
    jQuery(document).ready(function($) {
        // Função genérica para aplicar máscara numérica
        function aplicarMascaraNumerica(campo) {
            $(campo)
                .attr('maxlength', '11')
                .off('input')
                .on('input', function() {
                    let valorAtual = this.value;
                    let apenasNumeros = valorAtual.replace(/\D/g, '');
                    
                    if (apenasNumeros !== valorAtual) {
                        this.value = apenasNumeros;
                    }
                });
        }

        // Aplica nos campos de contato do grupo
        function aplicarMascaraGrupo() {
            $('.cmb-repeatable-group').each(function() {
                const tipo = $(this).find('select[id$="icone"]');
                const valor = $(this).find('input[id$="url_valor"]');
                
                // Aplica a máscara quando o valor é alterado
                valor.on('input', function() {
                    const tipoSelecionado = $(this).closest('.cmb-repeatable-grouping').find('select[id$="icone"]').val();
                    if (tipoSelecionado === 'fab fa-whatsapp' || tipoSelecionado === 'fa fa-phone') {
                        let valorAtual = this.value;
                        let apenasNumeros = valorAtual.replace(/\D/g, '');
                        
                        if (apenasNumeros !== valorAtual) {
                            this.value = apenasNumeros;
                        }
                    }
                });

                // Aplica a máscara quando o tipo é alterado
                tipo.on('change', function() {
                    const tipoSelecionado = $(this).val();
                    const valorCampo = $(this).closest('.cmb-repeatable-grouping').find('input[id$="url_valor"]');
                    
                    if (tipoSelecionado === 'fab fa-whatsapp' || tipoSelecionado === 'fa fa-phone') {
                        valorCampo.attr('maxlength', '11');
                        // Força a formatação do valor existente
                        let valorAtual = valorCampo.val();
                        valorCampo.val(valorAtual.replace(/\D/g, ''));
                    } else {
                        valorCampo.removeAttr('maxlength');
                    }
                });
                
                // Trigger inicial
                tipo.trigger('change');
            });
        }

        // Aplica nos campos individuais
        function aplicarMascaraCamposIndividuais() {
            // Lista de IDs dos campos que devem ter máscara numérica
            const camposNumericos = [
                '#alt_telefone_principal',
                '#alt_whatsapp_principal',
                '#alt_cep'
            ];

            camposNumericos.forEach(function(seletor) {
                aplicarMascaraNumerica(seletor);
            });
        }

        // Inicializa as máscaras
        aplicarMascaraGrupo();
        aplicarMascaraCamposIndividuais();

        // Observador para novos grupos
        $('.cmb-repeatable-group').on('cmb2_add_row', function() {
            aplicarMascaraGrupo();
        });
    });
    </script>
<?php
});