<?php
if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly
}

function registrar_api_rest_filiais()
{
    register_rest_route(
        'api/v1',
        '/filiais',
        [
            'methods' => WP_REST_Server::READABLE,
            'callback' => 'api_get_filiais'
        ]
    );

    register_rest_route(
        'api/v1',
        '/filiais',
        [
            'methods' => WP_REST_Server::EDITABLE,
            'callback' => 'api_post_filiais'
        ]
    );

    register_rest_route(
        'api/v1',
        '/filiais/(?P<id>\d+)',
        [
            'methods' => WP_REST_Server::EDITABLE,
            'callback' => 'api_post_filiais'
        ]
    );

    register_rest_route(
        'api/v1',
        '/filiais/(?P<id>\d+)',
        [
            'methods' => WP_REST_Server::DELETABLE,
            'callback' => 'api_delete_filiais'
        ]
    );
}


add_action('rest_api_init', 'registrar_api_rest_filiais');




function api_post_filiais($request)
{

    try {


        $user = get_user_altimus();

        
        if (!isset($user->data->ID)) {
            throw new \Exception('Usuário sem permissão', 403);
        }

       

        $id = $request['id'] ?? null;
        $post_title = $request['post_title'] ?? null;
        $post_content = $request['post_content'] ?? null;
        $alt_endereco_principal = $request['alt_endereco_principal'] ?? null;
        $alt_cidade_principal = $request['alt_cidade_principal'] ?? null;
        $alt_estado_principal = $request['alt_estado_principal'] ?? null;
        $alt_cep = $request['alt_cep'] ?? null;
        $alt_google_maps = $request['alt_google_maps'] ?? null;
        $alt_telefone_principal = $request['alt_telefone_principal'] ?? null;
        $alt_whatsapp_principal = $request['alt_whatsapp_principal'] ?? null;
        $alt_email_principal = $request['alt_email_principal'] ?? null;
        $alt_matriz = $request['alt_matriz'] ?? null;
        $alt_filial_mapa = $request['alt_filial_mapa'] ?? null;
        $alt_horario_funcionamento = $request['alt_horario_funcionamento'] ?? null;
        $alt_filiais_chave_altimus = $request['alt_filiais_chave_altimus'] ?? null;

        $my_post = array(
            'ID' => $id,
            'post_title' => wp_strip_all_tags($post_title),
            'post_content' => $post_content,
            'post_type' => 'filiais',
            'post_status' => 'publish',
            'post_author' => get_current_user_id()
        );


        if (empty($id)) {
            $post_id = wp_insert_post($my_post);
        } else {
            $post_id = $id;
            wp_update_post($my_post);
        }


        if (!add_post_meta($post_id, 'alt_endereco_principal', $alt_endereco_principal, true)) {
            update_post_meta($post_id, 'alt_endereco_principal', $alt_endereco_principal);
        }

        if (!add_post_meta($post_id, 'alt_cidade_principal', $alt_cidade_principal, true)) {
            update_post_meta($post_id, 'alt_cidade_principal', $alt_cidade_principal);
        }

        if (!add_post_meta($post_id, 'alt_estado_principal', $alt_estado_principal, true)) {
            update_post_meta($post_id, 'alt_estado_principal', $alt_estado_principal);
        }

        $alt_cep = preg_replace('/[^0-9]/', '', $alt_cep);

        if (!add_post_meta($post_id, 'alt_cep', $alt_cep, true)) {
            update_post_meta($post_id, 'alt_cep', $alt_cep);
        }


        if (!add_post_meta($post_id, 'alt_google_maps', $alt_google_maps, true)) {
            update_post_meta($post_id, 'alt_google_maps', $alt_google_maps);
        }

        $alt_telefone_principal = preg_replace('/[^0-9]/', '', $alt_telefone_principal);
        if (!add_post_meta($post_id, 'alt_telefone_principal', $alt_telefone_principal, true)) {
            update_post_meta($post_id, 'alt_telefone_principal', $alt_telefone_principal);
        }

        $alt_whatsapp_principal = preg_replace('/[^0-9]/', '', $alt_whatsapp_principal);
        if (!add_post_meta($post_id, 'alt_whatsapp_principal', $alt_whatsapp_principal, true)) {
            update_post_meta($post_id, 'alt_whatsapp_principal', $alt_whatsapp_principal);
        }

        if (!add_post_meta($post_id, 'alt_email_principal', $alt_email_principal, true)) {
            update_post_meta($post_id, 'alt_email_principal', $alt_email_principal);
        }

        if (!add_post_meta($post_id, 'alt_matriz', $alt_matriz, true)) {
            update_post_meta($post_id, 'alt_matriz', $alt_matriz);
        }

        if (!add_post_meta($post_id, 'alt_filial_mapa', $alt_filial_mapa, true)) {
            update_post_meta($post_id, 'alt_filial_mapa', $alt_filial_mapa);
        }

        if (!add_post_meta($post_id, 'alt_horario_funcionamento', $alt_horario_funcionamento, true)) {
            update_post_meta($post_id, 'alt_horario_funcionamento', $alt_horario_funcionamento);
        }

        if (!add_post_meta($post_id, 'alt_filiais_chave_altimus', $alt_filiais_chave_altimus, true)) {
            update_post_meta($post_id, 'alt_filiais_chave_altimus', $alt_filiais_chave_altimus);
        }

        $response = [
            'msg' => 'Adicionado/Alterado com sucesso',
            'id' => $post_id,

        ];
    } catch (\Exception $e) {
        $response = new WP_Error($e->getCode(), $e->getMessage(), ['status' => $e->getCode()]);
    }


    return rest_ensure_response($response);
}

function api_get_filiais()
{
    $args = array(
        'post_type' => 'filiais',
        'post_status' => array('publish')
    );

    $query = new WP_Query($args);
    $filiais = $query->posts;

    $return = [];
    foreach ($filiais as $filial) {


        $dataInfo['id'] = $filial->ID;
        $dataInfo['post_title'] = $filial->post_title;
        $dataInfo['post_content'] = $filial->post_content;
        $dataInfo['guid'] = $filial->guid;





        $dataInfo['alt_endereco_principal'] = get_post_meta($filial->ID, 'alt_endereco_principal', true) ?? null;
        $dataInfo['alt_cidade_principal'] = get_post_meta($filial->ID, 'alt_cidade_principal', true) ?? null;
        $dataInfo['alt_estado_principal'] = get_post_meta($filial->ID, 'alt_estado_principal', true) ?? null;
        $dataInfo['alt_cep'] = get_post_meta($filial->ID, 'alt_cep', true) ?? null;
        $dataInfo['alt_google_maps'] = get_post_meta($filial->ID, 'alt_google_maps', true) ?? null;
        $dataInfo['alt_telefone_principal'] = get_post_meta($filial->ID, 'alt_telefone_principal', true) ?? null;
        $dataInfo['alt_whatsapp_principal'] = get_post_meta($filial->ID, 'alt_whatsapp_principal', true) ?? null;
        $dataInfo['alt_email_principal'] = get_post_meta($filial->ID, 'alt_email_principal', true) ?? null;
        $dataInfo['alt_matriz'] = get_post_meta($filial->ID, 'alt_matriz', true) ?? null;
        $dataInfo['alt_filial_mapa'] = get_post_meta($filial->ID, 'alt_filial_mapa', true) ?? null;
        $dataInfo['alt_horario_funcionamento'] = get_post_meta($filial->ID, 'alt_horario_funcionamento', true) ?? null;
        $dataInfo['alt_filiais_chave_altimus'] = get_post_meta($filial->ID, 'alt_filiais_chave_altimus', true) ?? null;
        $return[] = $dataInfo;
    }


    return rest_ensure_response($return);
}


function api_delete_filiais($request)
{

    $user = get_user_altimus();

    try {

        //Validar informações obrigatórias
        if (empty($user)) {
            throw new \Exception('Usuário sem permissão', 403);
        }

        $data = $request->get_params();
        if (isset($data['id'])) {
            $post_id = $data['id'];
        }else{
            throw new \Exception('Nenhum ID informado');
        }



        $response = alt_delete_banners($post_id);

    } catch (\Exception $e) {


        $response = new WP_Error($e->getCode(), $e->getMessage(), ['status' => $e->getCode()]);


    }


    return rest_ensure_response($response);


}

if (!function_exists('alt_delete_filiais')) {
    function alt_delete_filiais($post_id)
    {


        $post = get_post($post_id);

        if (empty($post)) {
            return ['msg' => 'Nenhuma filial localizada'];
        };

        wp_delete_post($post_id, true);

        return ['msg' => 'Removido com sucesso'];
    }
}