<?php

add_shortcode('mostrar_banners', 'carregar_banners');
function carregar_banners()
{

    //"assets/js/owl.carousel.min.js"

    wp_enqueue_script('wpos-slick-jquery');
    global $post;
    ob_start();
    // WP Query Parameters
    $args = array(
        'post_type' => 'banners',
        'post_status' => array('publish')
    );

    $query = new WP_Query($args);
    $post_count = $query->post_count;
    if ($query->have_posts()) :
        $indice = 0;
        ?>

        <section id="banner2">


            <div id="carousel-example-generic" class="carousel slide" data-ride="carousel">
                <!-- Wrapper for slides -->

                <ol class="carousel-indicators">
                    <?php $i = 0; ?>
                    <?php while ($query->have_posts()) : $query->the_post(); ?>
                        <li data-target="#carousel-example-generic" data-slide-to="<?= $i ?>"
                            class="<?= $i == 0 ? 'active' : ''; ?>"></li>
                        <?php $i++; endwhile; ?>
                </ol>


                <div class="carousel-inner">

                    <?php while ($query->have_posts()) : $query->the_post();

                        $titulo = get_the_title();
                        $descricao = get_the_content();
                        $newBlank = get_post_meta(get_the_ID(), 'alt_banner_nova_guia', true) == 'sim' ? '_blank' : '_parent';
                        $url_imagem = get_post_meta(get_the_ID(), 'alt_banner_imagem', true) ?? null;

                        $url_video = get_post_meta(get_the_ID(), 'alt_banner_video', true) ?? null;
                        $link = get_post_meta(get_the_ID(), 'alt_banner_link', true) ?? null;
                        $exibir_texto = get_post_meta(get_the_ID(), 'alt_banner_exibir_texto', true) ?? false;

                        if (empty($url_imagem)) {
                            continue;
                        }


                        include('template/banner_slides.php');


                        $indice++;
                    endwhile;
                    ?>

                </div>

                <!-- Controls -->
                <a class="left carousel-control" href="#carousel-example-generic" role="button" data-slide="prev">
                    <div class="icon-prev"></div>
                </a>
                <a class="right carousel-control" href="#carousel-example-generic" role="button" data-slide="next">
                    <div class="icon-next"></div>
                </a>
            </div>

        </section>


    <?php

    endif;
    wp_reset_query();
    return ob_get_clean();


}

function alt_banners() {
    $args = array(
        'post_type'   => 'banners',
        'post_status' => 'publish',
        'posts_per_page' => -1 
    );

    $query = new WP_Query($args);
    $banners = [];

    if ($query->have_posts()) {
        while ($query->have_posts()) {
            $query->the_post();

            $titulo = get_the_title();
            $descricao = get_the_content();
            $newBlank = get_post_meta(get_the_ID(), 'alt_banner_nova_guia', true) == 'sim' ? '_blank' : '_parent';

            $link = get_post_meta(get_the_ID(), 'alt_banner_link', true) ?? null;
            $url_video = get_post_meta(get_the_ID(), 'alt_banner_video', true) ?? null;
            $exibir_texto = get_post_meta(get_the_ID(), 'alt_banner_exibir_texto', true) ?? false;

            $site_url = get_site_url();
            $url_imagem = get_post_meta(get_the_ID(), 'alt_banner_imagem', true) ?? null;
            $url_imagem_mobile = get_post_meta(get_the_ID(), 'alt_banner_imagem_mobile', true) ?? null;
            
            
            $site_url = str_replace(['http://', 'https://'], '', $site_url);
            $url_imagem = str_replace(['http://', 'https://'], '', $url_imagem);
            $url_imagem_mobile = str_replace(['http://', 'https://'], '', $url_imagem_mobile);

            $url_relativa_desktop = str_replace($site_url, '', $url_imagem);
            $url_relativa_mobile = str_replace($site_url, '', $url_imagem_mobile);

            if (empty($url_relativa_mobile) && !empty($url_relativa_desktop)) {
                $url_relativa_mobile = $url_relativa_desktop;
            } elseif (empty($url_relativa_desktop)) {
                continue; 
            }

            $banners[] = array(
                'titulo' => $titulo,
                'descricao' => $descricao,
                'link' => $link,
                'newBlank' => $newBlank,
                'url_video' => $url_video,
                'exibir_texto' => $exibir_texto,
                'url_relativa_desktop' => $url_relativa_desktop,
                'url_relativa_mobile' => $url_relativa_mobile
            );
        }

        wp_reset_postdata();
    }

    return $banners; 
}

