<?php


function alt_post_banners()
{

    //add_image_size('alt-banners', 1920, 830, true);

    $args_cursos_post_type = array(
        'labels' => array('name' => 'Banners', 'add_new' => 'Adicionar banner', 'add_new_item' => 'Titulo do banner', 'edit_item' => 'Titulo do banner'),
        'public' => true,
        'menu_icon' => 'dashicons-welcome-widgets-menus',
        'supports' => array('title', 'editor'),
        'show_ui' => true,
        'query_var' => true,
        'rewrite' => ['slug' => 'banners', 'with_front' => true],
        'publicly_queryable' => true,
        'register_meta_box_cb' => ''
    );
    register_post_type('banners', $args_cursos_post_type);
}

add_action('init', 'alt_post_banners');


function api_banners_get()
{

    $args = array(
        'post_type' => 'banners',
        'post_status' => array('publish')
    );

    $query = new WP_Query($args);
    $banners = $query->posts;

    $return = [];
    foreach ($banners as $banner) {


        $dataInfo['id'] = $banner->ID;
        $dataInfo['post_title'] = $banner->post_title;
        $dataInfo['post_content'] = $banner->post_content;
        $dataInfo['guid'] = $banner->guid;


        $dataInfo['alt_banner_imagem'] = get_post_meta($banner->ID, 'alt_banner_imagem', true) ?? null;
        $dataInfo['alt_banner_imagem_mobile'] = get_post_meta($banner->ID, 'alt_banner_imagem_mobile', true) ?? null;
        $dataInfo['alt_banner_nova_guia'] = get_post_meta($banner->ID, 'alt_banner_nova_guia', true) ?? null;
        $dataInfo['alt_banner_link'] = get_post_meta($banner->ID, 'alt_banner_link', true) ?? null;
        $return[] = $dataInfo;
    }


    return rest_ensure_response($return);
}


function get_user_altimus()
{
    $user = wp_get_current_user();

    if (!isset($user->data->ID)) {
        $usuario = getallheaders()['Usuario'];
        $user = get_user_by('login', $usuario);

        if (!empty($user)) {
            wp_set_current_user($user->data->ID);
        }
    }


    return wp_get_current_user();
}


if (!function_exists('alt_salvar_imagem_no_banner')) {
    function alt_salvar_imagem_no_banner($parent_post_id, $arrImagens)
    {
        //Ler todas as imagens
        $arrImg = [];
        foreach ($arrImagens as $indice => $image) {
            try {
                $url_original = $image;
                $upload_dir = wp_upload_dir();

                $i = 0;
                $limit_try = 4;
                while ($i < $limit_try) {

                    $image_data = file_get_contents($url_original);
                    if ($image_data) {
                        $i = $limit_try;
                    }
                    $i++;
                }


                if (empty($image_data)) {
                    throw new Exception('Não foi possível baixar a imagem: ' . $url_original);
                }

                $filename = basename($url_original);
                $pos = strpos($url_original, 's3.amazonaws.com');
                
                if(!empty($pos)){
                    $filename = bin2hex(random_bytes(10)).'.jpg';
                }

                if (wp_mkdir_p($upload_dir['path'])) {
                    $file = $upload_dir['path'] . '/' . $filename;
                } else {
                    $file = $upload_dir['basedir'] . '/' . $filename;
                }

                file_put_contents($file, $image_data);

                $wp_filetype = wp_check_filetype($filename, null);

                $attachment = array(
                    'post_mime_type' => $wp_filetype['type'],
                    'post_title' => sanitize_file_name($filename),
                    'post_content' => '',
                    'post_status' => 'inherit'
                );

                $attach_id = wp_insert_attachment($attachment, $file, $parent_post_id);

                require_once(ABSPATH . 'wp-admin/includes/image.php');
                $attach_data = wp_generate_attachment_metadata($attach_id, $file);
                $res1 = wp_update_attachment_metadata($attach_id, $attach_data);
                // update_post_meta($attach_id, '_wp_attachment_image_alt', 'Foto do veículo ' . $indice);

                $arrImg[$attach_id] = $upload_dir['baseurl'] . '/' . $attach_data['file'];
            } catch (Exception $e) {

                error_log($e->getMessage(), 3, 'erros-integracao-foto.log');
                continue;
            }
        } 
        
        //Serilizar os dados
        //Associar os dados com um campo
        $arrayValues = array_values($arrImg);
        if (!add_post_meta($parent_post_id, 'alt_banner_imagem', $arrayValues[0], true)) {
            update_post_meta($parent_post_id, 'alt_banner_imagem',$arrayValues[0]);
        }

        if(!empty($arrayValues[1])){
            if (!add_post_meta($parent_post_id, 'alt_banner_imagem_mobile', $arrayValues[1], true)) {
                update_post_meta($parent_post_id, 'alt_banner_imagem_mobile',$arrayValues[1]);
            }
        }else{
            if (!add_post_meta($parent_post_id, 'alt_banner_imagem_mobile', null, true)) {
                update_post_meta($parent_post_id, 'alt_banner_imagem_mobile',null);
            }
        }
    }
}

function api_token_validate()
{

    $curl = curl_init();
    $token = getallheaders()['Token'];
    curl_setopt_array($curl, array(
        CURLOPT_URL => 'https://tema4.carrobemcuidado.com.br/wp-json/jwt-auth/v1/token/validate',
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_ENCODING => '',
        CURLOPT_MAXREDIRS => 10,
        CURLOPT_TIMEOUT => 0,
        CURLOPT_FOLLOWLOCATION => true,
        CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
        CURLOPT_CUSTOMREQUEST => 'POST',
        CURLOPT_HTTPHEADER => array(
            'Content-Type: application/json',
            'Authorization: Bearer ' . $token
        ),
    ));

    $response_token = curl_exec($curl);

    curl_close($curl);

    $response_json = json_decode($response_token);
    $status = $response_json->data->status;
    return $status;
}

function api_banners_post($request)
{
    try {
        //$status = api_token_validate();
        //Validar informações obrigatórias

        //if ($status != 200) {
        //throw new \Exception('Token Inválido', 403);
        //}

        $user = get_user_altimus();

        if (!isset($user->data->ID)) {
            throw new \Exception('Usuário sem permissão', 403);
        }

        if (!isset($request['alt_banner_imagem']) || empty($request['alt_banner_imagem'])) {
            throw new \Exception('Nenhuma imagem desktop selecionada', 403);
        }


        $response = alt_editar_incluir_banner($request);
    } catch (\Exception $e) {

        $response = new WP_Error($e->getCode(), $e->getMessage(), ['status' => $e->getCode()]);
    }


    return rest_ensure_response($response);
}

function alt_editar_incluir_banner($request)
{

    $nome = $request['post_title'] ?? null;
    $description = $request['description'] ?? null;
    $id = $request['id'] ?? null;
    $alt_banner_imagem = $request['alt_banner_imagem'] ?? null;
    $alt_banner_imagem_mobile = $request['alt_banner_imagem_mobile'] ?? null;
    $alt_banner_nova_guia = $request['alt_banner_nova_guia'] ?? 'nao';
    $alt_banner_link = $request['alt_banner_link'] ?? null;


    $my_post = array(
        'ID' => $id,
        'post_title' => wp_strip_all_tags($nome),
        'post_type' => 'banners',
        'post_status' => 'publish',
        'post_author' => get_current_user_id()
    );



    if (empty($id)) {

        $post_id = wp_insert_post($my_post, true);
        if (is_wp_error($post_id)) {
            var_dump($post_id);
            die;
        }
    } else {

        $post_id = $id;
        wp_update_post($my_post);
    }

    if (!add_post_meta($post_id, 'alt_banner_nova_guia', $alt_banner_nova_guia, true)) {
        update_post_meta($post_id, 'alt_banner_nova_guia', $alt_banner_nova_guia);
    }

    if (!add_post_meta($post_id, 'alt_banner_link', $alt_banner_link, true)) {
        update_post_meta($post_id, 'alt_banner_link', $alt_banner_link);
    }

    $arrImg = [$alt_banner_imagem];
    if (!empty($alt_banner_imagem_mobile)) {
        $arrImg = [$alt_banner_imagem, $alt_banner_imagem_mobile];
    }

    alt_salvar_imagem_no_banner($post_id, $arrImg);


    $response = [
        'msg' => 'Adicionado com sucesso',
        'id' => $post_id,

    ];

    return $response;
}



function api_banners_delete($request)
{
    $user = get_user_altimus();

    try {

        //Validar informações obrigatórias
        if (empty($user)) {
            throw new \Exception('Usuário sem permissão', 403);
        }

        $data = $request->get_params();
        if (isset($data['id'])) {
            $post_id = $data['id'];
        } else {
            throw new \Exception('Nenhum ID informado');
        }



        $response = alt_delete_banners($post_id);
    } catch (\Exception $e) {


        $response = new WP_Error($e->getCode(), $e->getMessage(), ['status' => $e->getCode()]);
    }


    return rest_ensure_response($response);
}


if (!function_exists('alt_delete_banners')) {
    function alt_delete_banners($post_id)
    {


        $post = get_post($post_id);

        if (empty($post)) {
            return ['msg' => 'Banner não encontrado'];
        }

        wp_delete_attachment($post_id);


        if (empty($post)) {
            return ['msg' => 'Nenhum veiculo localizado'];
        };

        wp_delete_post($post_id, true);

        return ['msg' => 'Removido com sucesso'];
    }
}

function registrar_api_rest_banners()
{
    register_rest_route(
        'api/v1',
        '/banners',
        [
            'methods' => WP_REST_Server::READABLE,
            'callback' => 'api_banners_get'
        ]
    );

    register_rest_route(
        'api/v1',
        '/banners',
        [
            'methods' => WP_REST_Server::EDITABLE,
            'callback' => 'api_banners_post'
        ]
    );
    register_rest_route(
        'api/v1',
        '/banners/(?P<id>\d+)',
        [
            'methods' => WP_REST_Server::EDITABLE,
            'callback' => 'api_banners_post'
        ]
    );
    register_rest_route(
        'api/v1',
        '/banners/(?P<id>\d+)',
        [
            'methods' => WP_REST_Server::DELETABLE,
            'callback' => 'api_banners_delete'
        ]
    );

    register_rest_route(
        'api/v1',
        '/banners/(?P<id>\d+)',
        [
            'methods' => WP_REST_Server::DELETABLE,
            'callback' => 'api_banners_delete'
        ]
    );
}

add_action('rest_api_init', 'registrar_api_rest_banners');
