<?php
include 'exclusao_fotos.php';
include 'import_blog.php';

add_action('wp', 'activateME');

function activateME()
{
    $snNoticia = get_importar_noticias();
    if ($snNoticia) {
        if (!wp_next_scheduled('alt_cron_noticias')) {
            wp_schedule_event(current_time('timestamp'), 'twicedaily', 'alt_cron_noticias');
        }
    } else {
        wp_clear_scheduled_hook('alt_cron_noticias');
    }




    $sn_relatorio = get_emitir_relatorio_performance();
    if ($sn_relatorio) {
        if (!wp_next_scheduled('alt_relatorio_performance')) {
            wp_schedule_event(current_time('timestamp'), 'monthly', 'alt_relatorio_performance');
        }
    } else {
        wp_clear_scheduled_hook('alt_relatorio_performance');
    }

}

add_filter('cron_schedules', 'cron_add_weekly');
function cron_add_weekly($schedules)
{
    // Adds once weekly to the existing schedules.
    $schedules['weekly'] = array(
        'interval' => 604800,
        'display' => __('Once Weekly')
    );

    $schedules['monthly'] = array(
        'interval' => MONTH_IN_SECONDS,
        'display' => __('Once Monthly')
    );

    return $schedules;
}

