<?php

add_action('wp_ajax_nopriv_verificarVersao', 'verificarVersao');
add_action('wp_ajax_verificarVersao', 'verificarVersao');

/**
 * Verficar a versão atual do site
 */
function verificarVersao()
{
    global $wp_version;

    $filter = [];

    if (!empty($_GET['marca'])) {
        $filter[] = array(
            'taxonomy' => 'marca',
            'field' => 'slug',
            'terms' => $_GET['marca'],
        );
    }

    $dir = plugin_dir_path(__FILE__);
    $objPlugin = get_plugin_data($dir . './../altimus.php', false, false);


    $objTheme = wp_get_theme();
    $ultima_atualizacao = 'Nao definido';
    if (get_option('ultima_atualizacao_theme')) {
        $ultima_atualizacao = get_option('ultima_atualizacao_theme');
    }

    $versao_php = phpversion();
    $plugins = get_plugins();

    if ( ! class_exists( 'WP_Debug_Data' ) ) {
        require_once ABSPATH . 'wp-admin/includes/class-wp-debug-data.php';
    }

    $instalacao = new WP_Debug_Data;
    $tamanho_formatado = $instalacao->get_sizes();
    $dir_root = explode("/", getcwd());
	$key_home = array_search('home', $dir_root);

    $arrReturn['versaoPhp'] = $versao_php;
    $arrReturn['versaoWordpress'] = $wp_version;
    $arrReturn['versaoPluginAltimus'] = $objPlugin['Version'];
    $arrReturn['versaoTema'] = $objTheme->get('Version');
    $arrReturn['nomeTema'] = $objTheme->get('Name');
    $arrReturn['listaPlugins'] = listar_plugins();
    $arrReturn['espacoDiscoUtilizado'] = $tamanho_formatado['total_size']['size'];
    $arrReturn['data_atualizacao'] = $ultima_atualizacao;
    $arrReturn['ip_server'] =  $_SERVER['SERVER_ADDR'];
    $arrReturn['account'] = $dir_root[$key_home+1];
    
    echo json_encode($arrReturn);
    die;
}

function listar_plugins() {
    // Obtém a lista de plugins instalados
    $plugins = get_plugins();

    $lista_plugins = array();

    // Percorre cada plugin e obtém o nome e a versão
    foreach ($plugins as $plugin_file => $plugin_data) {
        $nome = $plugin_data['Name'];
        $versao = $plugin_data['Version'];

        // Adiciona o nome e a versão do plugin à lista
        $lista_plugins[] = $nome . ' - ' . $versao;
    }

    // Retorna a lista de plugins como JSON
    return (implode(',', $lista_plugins));
}

    

function agendarLimpeza()
{
    $user = get_user_altimus();

    if (!isset($user->data->ID)) {
        throw new \Exception('Usuário sem permissão', 403);
    }

    $response = wp_schedule_single_event(time()+ 10, 'wp_ajax_fotos_nao_usadas');

    $sucesso = 'Evento agendado com sucesso';
    $falha = 'O evento não foi agendado, verifique!';

    if($response) {
        return $sucesso;
    } else {
        return $falha;
    }

}

add_action('wp_ajax_agendar_limpeza', 'agendarLimpeza');

function alt_admin_remote_access($request)
{    
    try {
        $data = $request->get_params();

        $user = wp_authenticate($data['user'], $data['password']);

        if (!isset($user->data->ID)) {
            throw new \Exception('Usuário sem permissão', 403);
        }

        if (!is_wp_error($user)) {
            wp_clear_auth_cookie();
            wp_set_current_user($user->ID); // Set the current user detail
            wp_set_auth_cookie($user->ID); // Set auth details in cookie
            $url = get_admin_url();
            wp_redirect($url);
            exit();
        }

    } catch (Exception $e) {

        die($e->getMessage());
    }

    wp_redirect('/', 301);
}

add_action('wp_ajax_alt_admin_remote_access', 'alt_admin_remote_access');

function alt_update_plugin_theme($itemDir, $itemLocal, $itemInfo, $tempZipFile) {
    $uri = $itemInfo['PluginURI'] ?? $itemInfo['ThemeURI'];
    
    // Recupera as informações de atualização
    $response_primary = wp_safe_remote_get($uri);
    
    if (is_wp_error($response_primary)) {
        return [
            'success' => false,
            'message' => 'Erro ao obter informações de atualização: ' . $response_primary->get_error_message()
        ];
    }

    //Informações da atualização
    $update_info = json_decode(wp_remote_retrieve_body($response_primary), true);

    // Verifica se há uma versão mais recente disponível
    if (version_compare($update_info['version'], $itemInfo['Version'], '>')) {
        // Baixar o arquivo zip da nova versão
        $response = wp_remote_get($update_info['download_url'], array('timeout' => 300));
    
        if (is_wp_error($response)) {
            return [
                'success' => false,
                'message' => 'Erro ao baixar o arquivo zip da nova versão: ' . $response->get_error_message()
            ];
        } else {

            // Salvar o arquivo zip temporário
            file_put_contents($tempZipFile, wp_remote_retrieve_body($response));
        
            // Incluir o sistema de arquivos do WordPress
            require_once ABSPATH . '/wp-admin/includes/file.php';
            WP_Filesystem();
        
            // Descompactar o arquivo zip no diretório
            $unzip_result = unzip_file($tempZipFile, $itemDir);
        
            if (is_wp_error($unzip_result)) {
                return [
                    'success' => false,
                    'message' => 'Erro ao descompactar o arquivo zip: ' . $unzip_result->get_error_message()
                ];
            } else {
                if(isset($itemInfo['PluginURI'])) {
                    // Desativa o plugin ára limpar o cache
                    deactivate_plugins($itemLocal);

                    // Remover a versão antiga para evitar conflitos
                    delete_transient('altimus_version');
                    
                    //ativa após a atualização
                    activate_plugin($itemLocal);

                    // Atualizar a versão nas opções do WordPress
                    update_option('altimus_version', $update_info['version']);
                }                
                // Remover o arquivo zip temporário
                unlink($tempZipFile);  

                // Limpar o cache do browser
                wp_cache_flush();

                // Limpar o cache da GoCache
                clear_gocache_on_plugin_update();

                return [
                    'success' => true,
                    'message' => 'Item atualizado com sucesso para a versão ' . $update_info['version']
                ];
            }
        }                 
    }
    return [
        'success' => false,
        'message' => 'Erro na atualização.'
    ];  
}

function alt_update_manually($request)
{
    try {
        $user = get_user_altimus();

        if (!isset($user->data->ID)) {
            throw new \Exception('Usuário sem permissão', 403);
        }

        if (!is_wp_error($user)) {
            $output = [];
            $data = $request->get_params();
            
            if (in_array($data['type'], ['tema', 'ambos'])) {
                $itemDir = get_theme_root();
                $itemLocal = get_template().'/style.css';
                $itemInfo['ThemeURI'] = wp_get_theme()->get('ThemeURI');
                $itemInfo['Version'] = wp_get_theme()->get('Version');
                $tempZipFile = $itemDir . '/' . get_template(). '.zip';                
                array_push($output, ['tema' => alt_update_plugin_theme($itemDir, $itemLocal, $itemInfo, $tempZipFile)]);  
            } 
            
            if (in_array($data['type'], ['plugin', 'ambos'])) {                
                $itemDir = WP_PLUGIN_DIR;
                $itemLocal = 'altimus/altimus.php';
                $itemInfo = get_plugin_data($itemDir . '/altimus/altimus.php');
                $tempZipFile = $itemDir . '/altimus.zip';
                array_push($output, ['plugin' => alt_update_plugin_theme($itemDir, $itemLocal, $itemInfo, $tempZipFile)]);  
            }                        
            return $output;
        }
    } catch (Exception $e) {

        die($e->getMessage());
    }
}

add_action('wp_ajax_alt_update_manually', 'alt_update_manually');

/**
 * Registrar data de atualização do tema
 */
add_action('after_setup_theme', 'registrar_data_de_atualizacao');
function registrar_data_de_atualizacao()
{

    $current_version = wp_get_theme()->get('Version');
    $old_version = get_option('versao_do_thema');
    if ($old_version !== $current_version) {
        update_option('versao_do_thema', $current_version);
        update_option('ultima_atualizacao_theme', date('Y-m-d H:i:s'));
    }
}

function registrar_api_rest_info()
{
    register_rest_route(
        'api/v1',
        '/altimus_info',
        [
            'methods' => WP_REST_Server::READABLE,
            'callback' => 'verificarVersao'
        ]
    );

    register_rest_route(
        'api/v1',
        '/limpeza_fotos',
        [
            'methods' => WP_REST_Server::EDITABLE,
            'callback' => 'agendarLimpeza'
        ]
    );

    register_rest_route(
        'api/v1',
        '/acesso_altimus',
        [
            'methods' => WP_REST_Server::EDITABLE,
            'callback' => 'alt_admin_remote_access'
        ]
    );

    register_rest_route(
        'api/v1',
        '/update_altimus',
        [
            'methods' => WP_REST_Server::EDITABLE,
            'callback' => 'alt_update_manually'
        ]
    );
}


function expire_invalid()
{
    return time() + (60 * 60 * 24);
}

add_action('rest_api_init', 'registrar_api_rest_info');

/**
 * Limpa o cache da GoCache quando o plugin é ativado ou desativado.
 * 
 * Essa função é executada quando o plugin é ativado ou desativado. Ela
 * faz uma requisi o POST para a API da GoCache, passando a chave de
 * API e o par metro "purge_all" como true. Isso limpa todo o cache
 * da GoCache.
 */
function clear_gocache_on_plugin_update() {
    // Pegar o domínio do site para uso na URL de limpeza de cache
    $site = parse_url(home_url(), PHP_URL_HOST);
    $gocache_url = 'https://api.gocache.com.br/v1/cache/' . $site . '/all';
    $api_key = '9e56abf4735de1603f885fcee1c47913';

    // Requisição para limpar o cache
    $response = wp_remote_post( $gocache_url, [
        'headers' => [
            'Authorization' => 'Bearer ' . $api_key,
            'Content-Type'  => 'application/json',
        ],
        'body' => json_encode([
            'purge_all' => true,
        ]),
    ]);

    // Verificar e logar o resultado
    if ( is_wp_error( $response ) ) {
        error_log( 'Erro ao limpar cache da GoCache: ' . $response->get_error_message() );
    } else {
        error_log( 'Cache da GoCache limpo com sucesso para o site: ' . $site );
    }
}