let indexacaoEmAndamento = false;

jQuery(document).ready(function($) {
    // Função para controlar a visibilidade do botão de reindexação
    function toggleReindexButton() {
        var buscaSimilaridade = $('#busca_similaridade').val();
        var btnReindex = $('.cmb2-id-indexacao-manual');
        
        if (buscaSimilaridade === 'sim') {
            btnReindex.closest('.cmb-row').show();
        } else {
            btnReindex.closest('.cmb-row').hide();
        }
    }

    // Executa ao carregar a página
    toggleReindexButton();

    // Monitora mudanças no select de busca por similaridade
    $('#busca_similaridade').on('change', function() {
        toggleReindexButton();
    });

    // Handler para o clique no botão de reindexação
    $('#alt_group_listagem_indexacao_manual').on('click', function(e) {
        e.preventDefault();
        
        if (indexacaoEmAndamento) {
            alert('Uma indexação já está em andamento. Aguarde a conclusão.');
            return;
        }
        
        indexacaoEmAndamento = true;
        $(this).prop('disabled', true);
        
        var $button = $(this);
        var $spinner = $button.next('.spinner');
        var originalText = $button.text();
        
        // Desabilita o botão e mostra o spinner
        $button.prop('disabled', true);
        $spinner.addClass('is-active');
        $button.text('Reindexando...');
        
        // Faz a requisição AJAX
        $.ajax({
            url: ajaxurl,
            type: 'POST',
            data: {
                action: 'alt_index_reindexar_ajax',
                nonce: alt_index_vars.nonce
            },
            success: function(response) {
                if (response.success) {
                    alert(response.data);
                } else {
                    alert('Erro: ' + response.data);
                }
            },
            error: function() {
                alert('Erro ao comunicar com o servidor.');
            },
            complete: function() {
                // Restaura o estado original do botão
                $button.prop('disabled', false);
                $spinner.removeClass('is-active');
                $button.text(originalText);
                indexacaoEmAndamento = false;
            }
        });
    });
});
