// Adiciona os parâmetros de URL em um campo hidden do formulário WPCF7
// e salva os parâmetros em localStorage para uso futuro
document.addEventListener('DOMContentLoaded', function() {
    const url_to_format = window.location.search;
    const url_formatada = url_to_format.replace('?', '').replaceAll('&', ',');
    const myArray = url_formatada.split();
    const tags = myArray.toString();

    if(tags){
        const form = document.querySelector('.wpcf7-form');        
        const hiddenField = document.createElement('input');
        if (form && hiddenField) {
          hiddenField.type = 'hidden';
          hiddenField.name = 'utm_tags';
          hiddenField.value = tags;
          form.appendChild(hiddenField);
        }
    }
    
    // Verifica se a string contém os parâmetros de URL
    if(tags.includes('utm_')){
      window.localStorage.setItem('altimus_tags', myArray);
      let tagsSite = localStorage.getItem('altimus_tags');
      const inputField = document.getElementById('utm_tags');
      if(tagsSite !== null && inputField){
        inputField.value = tagsSite;
      }	
    }
}, false);
