jQuery(document).ready(function ($) {
    footerDynamic();
    
    if (jQuery("[name='alt_id']").length) {
        setTitle();

        $("[name='alt_modelo_complemento'], [name='alt_ano_mod'], [name='alt_ano_fab']").on('blur', function(){setTitle();});
        $("[name='alt_exibir_ano_titulo']").on('change', function(){setTitle();});
        $('input[name="tax_input[marca][]"], input[name="tax_input[modelo][]"]').on('change', function(){setTitle();});
    }
    if($("[name='paleta_cores']").val() == 'personalizar'){
        jQuery('.cmb2-id-cor-fundo').removeClass('hidden');
    }
    $("[name='paleta_cores']").on('change', function () {
        hidden_order($(this).val())
        jQuery('.cmb2-id-cor-fundo').removeClass('hidden');
    });    

    function setTitle() {
        var title = [];
        $('input[name="tax_input[marca][]"]:checked').each(function() {
            title.push($(this).parent().text());
        });
        $('input[name="tax_input[modelo][]"]:checked').each(function() {
            title.push($(this).parent().text());
        });
        title.push(jQuery("[name='alt_modelo_complemento']").val());
        if(jQuery("[name='alt_exibir_ano_titulo']").val() == 'ano_fabricacao') {
            title.push(jQuery("[name='alt_ano_fab']").val());
        } else {
            title.push(jQuery("[name='alt_ano_mod']").val());
        }
        jQuery("[name='post_title']").val(title.join(" "))
    }
    //seta as cores padrão de cada paleta
    function hidden_order(option){
        const paleta = {
            'orange': ['#f76d2b','#111'],
            'dark': ['#111','#ffffff'],
            'black': ['#000000','#fff'],
            'blue': ['#228dcb','#111'],
            'red': ['#fa2837','#111'],
            'green': ['#2dcc70','#111'],
            'altimus': ['#fa2837','#111'],
            'pink': ['#FF2761','#111'],
            'purple': ['#6054c2','#111'],
            'yellow': ['#ffc73c','#111'],
        }
        if (paleta[option]) {
            $("[name='cor_primaria']").val(paleta[option][0]);
            cor_primaria = $( "[name='cor_primaria']" ).parent().parent().parent();
            cor_primaria.children('button').css( "background-color", paleta[option][0]);
            texto_primaria = $( "[name='cor_primaria']" ).parent().parent().parent().parent();
            texto_primaria.children('p').text( "Selecione a cor primária do site - default " + paleta[option][0]);
            $("[name='cor_secundaria']").val(paleta[option][1]);
            cor_secundaria = $( "[name='cor_secundaria']" ).parent().parent().parent();
            cor_secundaria.children('button').css( "background-color", paleta[option][1] )
            texto_secundaria = $( "[name='cor_secundaria']" ).parent().parent().parent().parent();
            texto_secundaria.children('p').text( "Selecione a cor secundaria do site - default " + paleta[option][1]);        
        }
    }
});
jQuery(window).resize(function() {
    // setColumnCarousel(true);  
    footerDynamic();  
});
/*start - function for Theme 3*/
function setColumnCarousel(reload=false){
    var column = jQuery("#carousel-small").attr('data-items');
    if (is_mobile() && column !== 1) {
        changeColumn("#carousel-small", 'data-items', 1, reload)
    } else if (!is_mobile() && column == 1) {
        changeColumn("#carousel-small", 'data-items', 3, reload)
    }
}
function changeColumn(element, target, value, reload){
    $(element).attr(target, value);
    if (reload) {
        window.location.reload(true);    
    }
}
/*end - function for Theme 3*/
/*start - function for Theme 4*/
function footerDynamic() {
    if (is_mobile()) {
        jQuery('.link_rodape_content').removeClass('show');
        jQuery('.link_rodape_content').addClass('dafe');
    } else {
        jQuery('.link_rodape_content').addClass('show');
        jQuery('.link_rodape_content').removeClass('dafe');
    }
}
function is_mobile() {
    if (window.screen.width < 787) {
        return true;
    }
}
/*end - function for Theme 4*/