jQuery(document).ready(function($) {
  // Verifica se existe um campo de busca de veículo na página E se o autocomplete está habilitado nas configurações do plugin
  if (jQuery('input[name="veiculo"]').length && autocomplete_vars.enabled === 'sim') {
    jQuery('input[name="veiculo"]').autocomplete({
      source: function(request, response) {
        $.ajax({
            url: autocomplete_vars.ajax_url, // A URL do admin-ajax.php
            data: {
                action: 'autocomplete_action',  // A ação personalizada do Ajax
                term: request.term  // O termo buscado
            },
            success: function(data) {
                // Convertendo a resposta JSON para um formato correto, caso necessário
                var jsonData = JSON.parse(data);
                // Garantir que o Autocomplete use a propriedade 'label' para exibir
                response($.map(jsonData, function(item) {
                    return {
                        label: item.label,  // Exibe a propriedade 'label' no autocomplete
                        value: item.value   // Utiliza o 'value' ao selecionar um item
                    };
                }));
            }
        });
      },
      minLength: 2, // Define o número mínimo de caracteres para iniciar a busca
    });
  }
});