document.addEventListener('DOMContentLoaded', function () {

    // Função para exibir mensagens de sucesso ou erro
    function showMessage(message, type) {
        const formContainer = document.querySelector('.wpcf7'); // Verifique se o seletor está correto
        if (!formContainer) return; // Caso o contêiner do mensagem não exista

        // Remover mensagem existente
        const existingMessage = document.querySelector('.altimus-message');
        if (existingMessage) {
            existingMessage.remove();
        }

        // Criar nova mensagem
        const messageDiv = document.createElement('div');
        messageDiv.classList.add('altimus-message', `altimus-message-${type}`);
        messageDiv.textContent = message;

        // Inserir a mensagem no DOM (antes ou depois do mensagem)
        formContainer.insertAdjacentElement('beforebegin', messageDiv);

        // Remover a mensagem automaticamente após alguns segundos
        setTimeout(() => {
            messageDiv.remove();
        }, 5000); // 5 segundos
    }
   
    document.addEventListener('wpcf7spam', function(event){
        showMessage('Tentativa de envio automatizado bloqueada.', 'error');        
    }, false);

    // Evento para erro de validação
    document.addEventListener('wpcf7invalid', function(event) {
        showMessage('Ops, parece que houve um problema ao enviar sua mensagem.', 'error');
    }, false);

    // Evento para falha no envio de e-mail
    document.addEventListener('wpcf7mailfailed', function(event) {
        showMessage('Houve um erro ao enviar a mensagem. Tente novamente.', 'error');
    }, false);

    // Evento para sucesso no envio
    document.addEventListener('wpcf7mailsent', function(event) {
        showMessage('Mensagem enviada com sucesso!', 'success');
        
        // Limpar o mensagem após o envio bem-sucedido
        const form = event.target;
        form.reset();
    }, false);
});
