<?php
/*
  Name: Altimus
  Plugin Name: Altimus
  Plugin URI: http://cdn-wordpress.altimus.com.br/atualizacoes/producao/plugin-altimus/plugin.json
  Description: Plugin de integração com o sistema Altimus - Oficial
  Author: Altimus
  Version: 2025.06.10.1440
  Author URI: http://www.altimus.com.br/
  Text Domain: altimus
 */
define('MY_PLUGIN_PATH', plugin_dir_path(__FILE__));
define('LOGO_BRANCA', plugin_dir_url(__FILE__) . '/img/logos/logo-branca.svg');
define('LOGO_COLORIDA', plugin_dir_url(__FILE__) . '/img/logos/logo-colorida.png');

// Filtro para desabilitar o XML-RPC
add_filter('xmlrpc_enabled', '__return_false');
// Bloqueia diretamente o acesso ao xmlrpc.php
add_action('init', function () {
    if (strpos($_SERVER['REQUEST_URI'], 'xmlrpc.php') !== false) {
        die('XML-RPC desativado.');
    }
});
/*
 * Função para pegar a versão do plugin
 */
if (!function_exists('get_plugin_data')) {
    require_once(ABSPATH . 'wp-admin/includes/plugin.php');
    $plugin_data = get_plugin_data(__FILE__);
    $plugin_version = $plugin_data['Version'];

    $versao = intval(str_replace('.', '', $plugin_version));

    define('VERSION_PLUGIN_ALTIMUS', $versao);
}

//Customização
require_once 'inc/setup.php';

register_activation_hook(__FILE__, 'create_database_lead');

function alt_mailtrap($phpmailer)
{
    $phpmailer->isSMTP();
    $phpmailer->Host = 'smtp.mailtrap.io';
    $phpmailer->SMTPAuth = true;
    $phpmailer->Port = 2525;
    $phpmailer->Username = 'bc74cf83536fbc';
    $phpmailer->Password = '2690ebf02e5427';
}

if (in_array($_SERVER['REMOTE_ADDR'], array('127.0.0.1', '::1'))) {
    add_action('phpmailer_init', 'alt_mailtrap');
}

/*
 * Função para atualizar automaticamente o plugin
 */
function auto_update_specific_plugins($update, $item)
{
    // Array of plugin slugs to always auto-update
    $plugins = array(
        'altimus'
    );

    if (in_array($item->slug, $plugins)) {
        return true;
    } else {
        return $update;
    }
}

function auto_update_specific_theme($update, $item)
{

    // Array of plugin slugs to always auto-update
    $themes = array(
        'altimus',
        'altimus2',
        'altimus3',
        'altimus4',
        'altimus5'
    );

    if (isset($item->slug) && in_array($item->slug, $themes)) {
        return true;
    } else {
        return $update;
    }
}

/**
 * Atualizar automaticamente tema e plugin
 */
add_filter('auto_update_theme', 'auto_update_specific_theme', 10, 2);
add_filter('auto_update_plugin', 'auto_update_specific_plugins', 10, 2);

//Importa os arquivos de conteúdo dinamicos
require_once 'inc/textos_dinamicos.php';
require_once 'inc/elementos_dinamicos.php';

//Importar dados iniciais
require_once 'inc/import/ImportarXml.php';
require_once 'inc/import/ImportarPaginasXml.php';

require_once 'inc/schema.php';

require_once 'inc/seguranca.php';

require_once 'inc/api.php';

require_once 'inc/submit.php';

require_once 'inc/imagensResize.php';

require_once 'inc/report/report.php';

require_once 'inc/util.php';
require_once 'inc/setup/database.php';

require_once 'inc/taxonomy.php';
require_once 'inc/sidebar.php';
require_once 'inc/cronjobs.php';
require_once 'inc/shortcodes.php';
require_once 'inc/widget.php';

//TYPE POSTS
require_once 'inc/custom-post/depoimentos.php';
//require_once 'inc/custom-post/banners.php';
require_once 'inc/custom-post/banners/banners.php';
require_once 'inc/custom-post/filiais/filiais.php';
require_once 'inc/custom-post/galeria.php';
require_once 'inc/custom-post/time.php';
require_once 'inc/custom-post/veiculos.php';
require_once 'inc/custom-post/popups.php';

/**
 * Ativar cronjob de importação de conteúdo
 */
require_once 'inc/tgm.php';

/**
 * Criação da LP
 */

require_once 'inc/lp/index.php';
require_once 'inc/lp/setup-lp.php';

/**
* Importação de conteúdo do portal
*/

require_once 'inc/portal/portal.php';

add_filter('sidebar_widget_footer', 'footer_widgets');

/* Register our callback function */
function footer_widgets($params)
{
    return $params;
}

/**
 * Habilitar do_shorcode in Widget HTML
 */
add_filter('widget_custom_html_content', 'do_shortcode');

/**
 * VERIFICAR SE PRECISA DE ATUALIZAÇÃO
 */

require 'plugin-update-checker/plugin-update-checker.php';

$myUpdateChecker = Puc_v4_Factory::buildUpdateChecker(
    get_plugin_data( __FILE__ )['PluginURI'],
    __FILE__, //Full path to the main plugin file or functions.php.
    'altimus'
);

/**
 * DISABILITAR O GUTTEMBERBE
 */

if (!function_exists('alt_disable_gutenberg')) {
    function alt_disable_gutenberg()
    {

        global $wp_filter;

        $callbacks_array = $wp_filter['init']->callbacks;

        foreach ($wp_filter as $tag => $priorities) {
            foreach ($priorities->callbacks as $priority => $callback_data) {
                foreach ($callback_data as $callback_function_name => $callback_function_data) {

                    if (strpos($callback_function_name, 'disable_gutenberg') !== false) {
                        continue;
                    }

                    // Gutenberg disabler
                    if (strpos($callback_function_name, 'gutenberg') !== false || strpos($callback_function_name, 'block_editor')) {

                        remove_filter($tag, $callback_function_name, $priority);
                    }
                }
            }
        }

        $wp_filter['init']->callbacks = $callbacks_array;

        add_filter('use_block_editor_for_post_type', '__return_false');
    }
}
add_action('admin_init', 'alt_disable_gutenberg');

add_action('admin_bar_menu', 'toolbar_link_to_mypage', 998);
function toolbar_link_to_mypage($wp_admin_bar)
{

    $args0 = array(
        'id' => 'alt_menu_altimus',     // id of the existing child node (New > Post)
        'title' => 'Configurações Altimus', // alter the title of existing node
        'parent' => false,          // set parent to false to make it a top level (parent) node
    );

    $args1 = array(
        'id' => 'alt_setup',     // id of the existing child node (New > Post)
        'title' => 'Configurações gerais', // alter the title of existing node
        'href' => '/wp-admin/admin.php?page=alt_group_setup',
        'parent' => 'alt_menu_altimus',          // set parent to false to make it a top level (parent) node
    );

    $args2 = array(
        'id' => 'alt_cores',     // id of the existing child node (New > Post)
        'title' => 'Configurações de cores', // alter the title of existing node
        'href' => '/wp-admin/admin.php?page=alt_group_cores',
        'parent' => 'alt_menu_altimus',          // set parent to false to make it a top level (parent) node
    );

    $args3 = array(
        'id' => 'alt_header',     // id of the existing child node (New > Post)
        'title' => 'Configurações Header', // alter the title of existing node
        'href' => '/wp-admin/admin.php?page=alt_group_contato_header',
        'parent' => 'alt_menu_altimus',          // set parent to false to make it a top level (parent) node
    );

    $args4 = array(
        'id' => 'alt_midias',     // id of the existing child node (New > Post)
        'title' => 'Configurações Mídias sociais', // alter the title of existing node
        'href' => '/wp-admin/admin.php?page=alt_group_midias_sociais',
        'parent' => 'alt_menu_altimus',          // set parent to false to make it a top level (parent) node
    );

    $args5 = array(
        'id' => 'alt_listagem',     // id of the existing child node (New > Post)
        'title' => 'Configurações listagem (Estoque)', // alter the title of existing node
        'href' => '/wp-admin/admin.php?page=alt_group_listagem',
        'parent' => 'alt_menu_altimus',          // set parent to false to make it a top level (parent) node
    );

    $args6 = array(
        'id' => 'alt_detalhes',     // id ofaltimus/woocommerce/inc/functions.php the existing child node (New > Post)
        'title' => 'Configurações detalhes do veículo', // alter the title of existing node
        'href' => '/wp-admin/admin.php?page=alt_group_setup_detalhes',
        'parent' => 'alt_menu_altimus',          // set parent to false to make it a top level (parent) node
    );

    $args7 = array(
        'id' => 'alt_contatos',     // id ofaltimus/woocommerce/inc/functions.php the existing child node (New > Post)
        'title' => 'Configurações WhatsApp', // alter the title of existing node
        'href' => '/wp-admin/admin.php?page=alt_group_contato_header',
        'parent' => 'alt_menu_altimus',          // set parent to false to make it a top level (parent) node
    );
    
    $args7 = array(
        'id' => 'alt_setup_integracao',     // id ofaltimus/woocommerce/inc/functions.php the existing child node (New > Post)
        'title' => 'Configuração de integração', // alter the title of existing node
        'href' => '/wp-admin/admin.php?page=alt_group_integracao',
        'parent' => 'alt_menu_altimus',          // set parent to false to make it a top level (parent) node
    );

    $wp_admin_bar->add_node($args0);
    $wp_admin_bar->add_node($args1);
    $wp_admin_bar->add_node($args2);
    $wp_admin_bar->add_node($args3);
    $wp_admin_bar->add_node($args4);
    $wp_admin_bar->add_node($args5);
    $wp_admin_bar->add_node($args6);
    $wp_admin_bar->add_node($args7);
}

//Removes the meta tag generator name and version that generated with the wp_head()function.
remove_action('wp_head', 'wp_generator');

add_filter('wpcf7_spam', '__return_false');

/**
 * Alterar titulo
 */
include_once(ABSPATH . 'wp-admin/includes/plugin.php');
if (!is_plugin_active('wordpress-seo/wp-seo.php')) {

    add_filter('document_title_parts', 'alt_change_document_title_parts', 1, 1);
    add_action('wp_head', 'alt_set_description', 1);

    function alt_set_description()
    {

        $arrInfo = get_info_principal(true);
        if ($arrInfo) {
            $descricao = "A melhor revenda de veículos em " . $arrInfo['cidade'];
            $descricao .= " Encontre os melhores veículos perto de você. Diversas marcas e modelos, acesse nosso estoque";

            echo '<meta name="description" content="' . $descricao . '"/>';    
        }
    }

    function alt_change_document_title_parts($title_parts)
    {

        $arrInfo = get_info_principal(true);
        $titulo = $arrInfo['nome_fantasia'] ?? '';
        $cidade = $arrInfo['cidade'] ?? '';
        $estado = $arrInfo['estado'] ?? '';
        $subTitulo = $cidade . ' - ' . $estado;


        if (is_front_page()) {
            $title_parts['tagline'] = $subTitulo;
            $title_parts['title'] = $titulo;
        } else {
            $title_parts['site'] = $titulo;
            $title_parts['tagline'] = $subTitulo;
        }
        return $title_parts;
    }
}

require_once 'inc/lgpd.php';
require_once 'inc/update_cron.php';
require_once 'inc/custom-post/veiculos/indexacao.php';

// Importar dados iniciais
require_once 'inc/import/ImportarXml.php';

// Carregamento de traduções
function altimus_load_textdomain() {
    load_plugin_textdomain('altimus', false, dirname(plugin_basename(__FILE__)) . '/languages');
}
add_action('init', 'altimus_load_textdomain', 1); // Prioridade 1 para carregar antes de outros hooks 'init'

// Scripts e estilos do frontend
function altimus_enqueue_frontend_scripts() {
    // Somente carregue estes scripts no frontend
    if (!is_admin()) {
        wp_enqueue_script('shorcode-whatsapp', plugins_url('altimus') . '/inc/shortcodes/AltWhatsApp/whatsapp_shortcode.js', ['jquery'], VERSION_PLUGIN_ALTIMUS, false);
        wp_enqueue_style('shorcode-whatsapp-style', plugins_url('altimus') . '/inc/shortcodes/AltWhatsApp/style_whatsapp.css', [], VERSION_PLUGIN_ALTIMUS, 'all');
    }
}
add_action('wp_enqueue_scripts', 'altimus_enqueue_frontend_scripts');

// Scripts e estilos do admin
function altimus_admin_enqueue_scripts() {
    wp_enqueue_script('altimus-indexacao-admin', plugins_url('assets/js/indexacao-admin.js', __FILE__), array('jquery'), VERSION_PLUGIN_ALTIMUS, true);
    wp_enqueue_script('altimus-dynamic-fields.js', plugin_dir_url(__FILE__) . 'js/altimus-dynamic-fields.js', array('jquery'), '1.0', true);
    wp_enqueue_style('altimus-admin-estilo', plugins_url('assets/css/altimus-admin-style.css', __FILE__));
}
add_action('admin_enqueue_scripts', 'altimus_admin_enqueue_scripts');

function altimus_enqueue_scripts() {
        // Estilos principais
        wp_enqueue_style('altimus-alert', plugins_url('assets/css/altimus-alert.css', __FILE__));
        wp_enqueue_style('jquery-ui-autocomplete-style', 'https://code.jquery.com/ui/1.12.1/themes/base/jquery-ui.css');

        // Scripts principais
        wp_enqueue_script('altimus-utm.js', plugin_dir_url('altimus') . '/altimus/assets/js/altimus-utm.js', array(), VERSION_PLUGIN_ALTIMUS, ['strategy' => 'async']);    
        
        // Scripts adicionais
        wp_enqueue_script('altimus-alert-script', plugins_url('assets/js/altimus-alert.js', __FILE__), array('jquery'), null, true);
        wp_enqueue_script('mascara', plugins_url('assets/js/mascara.js', __FILE__), array('jquery'), VERSION_PLUGIN_ALTIMUS, ['strategy' => 'async']);
        wp_enqueue_script('jquery-ui-autocomplete');
        wp_enqueue_script('altimus-autocomplete', plugins_url('assets/js/altimus-autocomplete.js', __FILE__), array('jquery', 'jquery-ui-autocomplete'), VERSION_PLUGIN_ALTIMUS, ['strategy' => 'async']);
        
        // Localize script para autocomplete
        wp_localize_script('altimus-autocomplete', 'autocomplete_vars', array(
            'ajax_url' => admin_url('admin-ajax.php'),
            'enabled' => alt_get_busca_autocomplete() ? 'sim' : 'nao'
        ));
}
add_action('wp_enqueue_scripts', 'altimus_enqueue_scripts');


/**
 * Criar usuário e permissões.
 * A importação foi adicionada nesse ponto do arquivo
 * para garantir que sobrescreva todos os menus
 * préviamente criados.
 */
require_once 'inc/user.php';

/**
 * DISABILITAR O GUTTEMBERBE
 */

if (!function_exists('alt_disable_gutenberg')) {
    function alt_disable_gutenberg()
    {

        global $wp_filter;

        $callbacks_array = $wp_filter['init']->callbacks;

        foreach ($wp_filter as $tag => $priorities) {
            foreach ($priorities->callbacks as $priority => $callback_data) {
                foreach ($callback_data as $callback_function_name => $callback_function_data) {

                    if (strpos($callback_function_name, 'disable_gutenberg') !== false) {
                        continue;
                    }

                    // Gutenberg disabler
                    if (strpos($callback_function_name, 'gutenberg') !== false || strpos($callback_function_name, 'block_editor')) {

                        remove_filter($tag, $callback_function_name, $priority);
                    }
                }
            }
        }

        $wp_filter['init']->callbacks = $callbacks_array;

        add_filter('use_block_editor_for_post_type', '__return_false');
    }
}
add_action('admin_init', 'alt_disable_gutenberg');

add_filter('wpcf7_form_elements', function($form) {
    $honeypot = '<input type="checkbox" name="meucampo_honeypot" tabindex="-1" autocomplete="off" style="opacity:0" />';
    return $form . $honeypot;
});

// Validando honeypot
add_filter('wpcf7_validate', function($result, $tags) {
    $submission = WPCF7_Submission::get_instance();
    if (!$submission) return $result;

    $data = $submission->get_posted_data();

    error_log('Validação personalizada executada.');
    error_log('Dados: ' . print_r($data, true));

    if (!empty($data['meucampo_honeypot']) && $data['meucampo_honeypot'] === 'on') {
        $result->invalidate('', 'Tentativa de envio automatizado bloqueada.');
        $submission->set_status('spam');
    }
    return $result;
}, 10, 2);


// Validando palavras proibidas, links e etc
add_filter('wpcf7_validate', function ($result, $tags) {
    $submission = WPCF7_Submission::get_instance();
    if (!$submission) return $result;

    $data = $submission->get_posted_data();
    $message = implode(' ', $data);

    $palavras_proibidas = ['http', 'https', 'promoção', 'desconto', 'dinheiro', 'lucro', '💰', '🔞', 'xxx', 'viagra', 'base64'];

    foreach ($palavras_proibidas as $palavra) {
        if (stripos($message, $palavra) !== false) {
            $result->invalidate('', 'Mensagem bloqueada por conter termos suspeitos.');
            break;
        }
    }

    return $result;
}, 10, 2);


add_filter('wpcf7_validate', function ($result, $tags) {
    $ip = $_SERVER['REMOTE_ADDR'];
    $transient_key = 'cf7_ip_' . md5($ip);
    $dados = get_transient($transient_key);

    if (!$dados) {
        $dados = [
            'count' => 1,
            'first_time' => time()
        ];
    } else {
        // Ainda dentro da janela de 1 hora
        if (time() - $dados['first_time'] <= 3600) {
            if ($dados['count'] >= 3) {
                // BLOQUEIA e mostra no front-end
                $result->invalidate('', 'Você já enviou 3 mensagens. Tente novamente em 1 hora.');
                return $result;
            } else {
                $dados['count']++;
            }
        } else {
            // Expirou o tempo, reinicia o contador
            $dados = [
                'count' => 1,
                'first_time' => time()
            ];
        }
    }

    // Atualiza o transient com 1h de expiração
    set_transient($transient_key, $dados, 3600);

    return $result;
}, 10, 2);

// Essa função retorna o prefixo da tabela de forma dinamica. 
// Importante ressaltar que ela retorna da seguinte forma "wp_". 
// Isso significa que o "_" ja faz parte do prefixo
function alt_prefixo(){
    global $wpdb;
    $prefixo = $wpdb->prefix;
    return $prefixo;
}

// Segredo para o hash — você pode mudar para algo mais aleatório ou usar uma constante
define('CAPTCHA_SECRET_KEY', 'chave-secreta-123');

// Exibir a pergunta no formulário de login
function captcha_pergunta_login() {
    $perguntas = [
        'Quanto é 3 + 5?' => 8,
        'Quanto é 10 - 7?' => 3,
        'Quanto é 4 x 2?' => 8,
        'Quanto é 13 - 3?' => 10,
        'Quanto é 4 + 3?' => 7,
        'Quanto é 15 / 3?' => 5,
        'Quanto é 10 + 12?' => 22,
        'Quanto é 31 + 3?' => 34
    ];

    $pergunta = array_rand($perguntas);
    $resposta = $perguntas[$pergunta];

    // Criar hash da resposta
    $resposta_hash = hash_hmac('sha256', $resposta, CAPTCHA_SECRET_KEY);

    echo '<p>';
    echo '<label for="captcha_resposta">' . esc_html($pergunta) . '</label>';
    echo '<input type="text" name="captcha_resposta" id="captcha_resposta" required>';
    echo '<input type="hidden" name="captcha_hash" value="' . esc_attr($resposta_hash) . '">';
    echo '</p>';
}
add_action('login_form', 'captcha_pergunta_login');

// Validação do CAPTCHA
function validar_captcha_login($user, $password) {
    // Ignora captcha se a requisição for para o endpoint jwt-auth/v1/token
    if (
    defined('REST_REQUEST') && REST_REQUEST &&
    isset($_SERVER['REQUEST_URI']) && (
        strpos($_SERVER['REQUEST_URI'], 'jwt-auth/v1/token') !== false ||
        strpos($_SERVER['REQUEST_URI'], 'wp-json/api/v1/acesso_altimus') !== false
    )
    ) {
        return $user;
    }

    if ($_SERVER['REQUEST_METHOD'] === 'POST') {
        $resposta_usuario = trim($_POST['captcha_resposta'] ?? '');
        $hash_recebido    = $_POST['captcha_hash'] ?? '';

        // Recriar o hash com base na resposta do usuário
        $hash_gerado = hash_hmac('sha256', $resposta_usuario, CAPTCHA_SECRET_KEY);

        if ($hash_gerado !== $hash_recebido) {
            return new WP_Error('captcha_incorreto', '<strong>ERRO:</strong> CAPTCHA incorreto.');
        }
    }

    return $user;
}
add_filter('authenticate', 'validar_captcha_login', 20, 2);



// Adicionando um honeypot para bots
function adicionar_honeypot_no_login() {
    ?>
    <p style="display: none;">
        <label for="captcha_honeypot">Deixe este campo vazio</label>
        <input type="text" name="captcha_honeypot" id="captcha_honeypot">
    </p>
    <?php
}
add_action('login_form', 'adicionar_honeypot_no_login');

// Função para validar se o honeypot foi preenchido 
function validar_honeypot_no_login($user, $password) {
    if ($_SERVER['REQUEST_METHOD'] === 'POST') {
        if (!empty($_POST['captcha_honeypot'])) {
            return new WP_Error('bot_detectado', '<strong>ERRO:</strong> Acesso negado.');
        }
    }
    return $user;
}
add_filter('authenticate', 'validar_honeypot_no_login', 20, 2);

// Desativando edição de arquivos no plugin e tema pelo painel administrativo do wordpress 
add_action('init', function() {
    if (!defined('DISALLOW_FILE_EDIT')) {
        define('DISALLOW_FILE_EDIT', true);
    }
});

// impedindo uploads de arquivos .php na pasta de uploads do wordpress
add_filter('wp_handle_upload_prefilter', function($file) {
    if (preg_match('/\.(php|php5|phtml|php7|php8)$/i', $file['name'])) {
        $file['error'] = 'Uploads de arquivos PHP não são permitidos!';
    }
    return $file;
});

// impedindo execução de php na pasta uploads do wordpress 
add_action('init', function() {
    $uri = $_SERVER['REQUEST_URI'];
    if (strpos($uri, '/wp-content/uploads/') !== false && preg_match('/\.(php|php5|phtml|php7|php8)$/i', $uri)) {
        wp_die('Acesso negado.', 'Erro 403', array('response' => 403));
        exit;
    }
});

// Função para pegar IP do usuário
function alt_get_ip() {
    return $_SERVER['REMOTE_ADDR'];
}

// Verifica se o IP está bloqueado
function alt_ip_bloqueado($ip) {
    $data = get_option("alt_tentativas_$ip");
    $max_tentativas = 3;
    $tempo_bloqueio = 15 * 60; // 15 minutos

    if (!$data) return false;

    if ($data['count'] >= $max_tentativas) {
        $tempo_passado = time() - $data['ultimo_erro'];
        if ($tempo_passado < $tempo_bloqueio) {
            return true;
        } else {
            // tempo passou, reseta
            delete_option("alt_tentativas_$ip");
            return false;
        }
    }

    return false;
}

// Hook que roda quando o login falha
add_action('wp_login_failed', function($username) {
    $ip = alt_get_ip();

    $data = get_option("alt_tentativas_$ip", ['count' => 0, 'ultimo_erro' => time()]);
    $data['count'] += 1;
    $data['ultimo_erro'] = time();

    update_option("alt_tentativas_$ip", $data);
});

// Hook antes de autenticar
add_filter('authenticate', function($user, $username, $password) {
    $ip = alt_get_ip();

    if (alt_ip_bloqueado($ip)) {
        return new WP_Error('bloqueado', __('Você excedeu o número de tentativas. Tente novamente em 15 minutos.'));
    }

    return $user;
}, 30, 3);

// Se login for bem-sucedido, limpa tentativas
add_action('wp_login', function($user_login, $user) {
    $ip = alt_get_ip();
    delete_option("alt_tentativas_$ip");
}, 10, 2);

// Ativando atualizações automáticas para todos os plugins
add_filter('auto_update_plugin', '__return_true');

